package com.amity.socialcloud.sdk.core.data.ad

import androidx.room.Dao
import androidx.room.Query
import com.amity.socialcloud.sdk.entity.core.ad.AdEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Single


@Dao
abstract class AdDao : EkoObjectDao<AdEntity>() {
    @Query("DELETE from ad")
    abstract override fun deleteAll()

    @Query("SELECT *" +
            " from ad" +
            " where ad.adId = :adId" +
            " LIMIT 1")
    abstract fun getByIdImpl(adId: String): Single<List<AdEntity>>
    fun getById(adId: String): Single<List<AdEntity>> {
        return getByIdImpl(adId)
    }

    @Query("SELECT *" +
            " from ad" +
            " where ad.adId = :adId" +
            " LIMIT 1")
    abstract fun getByIdNowImpl(adId: String): AdEntity?
    override fun getByIdNow(adId: String): AdEntity? {
        return getByIdNowImpl(adId)
    }

    @Query("SELECT *" +
            " from ad")
    abstract fun getAllNowImpl(): List<AdEntity>
    fun getAllNow(): List<AdEntity> {
        return getAllNowImpl()
    }

    @Query("SELECT *" +
            " from ad" +
            " where ad.adId IN (:ids)")
    abstract fun getByIdsNowImpl(ids: List<String>): List<AdEntity>
    override fun getByIdsNow(ids: List<String>): List<AdEntity> {
        return getByIdsNowImpl(ids)
    }
}