package com.amity.socialcloud.sdk.chat.data.marker.message

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.MessageMarkerEntity
import com.ekoapp.ekosdk.internal.api.dto.MessageMarkerDto
import org.joda.time.DateTime

internal class MessageMarkerEntityMapper : EntityMapper<MessageMarkerDto, MessageMarkerEntity>() {

    override fun map(list: List<MessageMarkerDto>): List<MessageMarkerEntity> {
        return list.map { map(it) }
    }

    fun map(dto: MessageMarkerDto) : MessageMarkerEntity {
        return MessageMarkerEntity().apply {
            messageId = dto.messageId
            subChannelId = dto.subChannelId
            readCount = dto.readCount
            deliveredCount = dto.deliveredCount
            createdAt = dto.createdAt ?: DateTime.now()
            updatedAt = dto.updatedAt ?: DateTime.now()
        }
    }

}