package com.ekoapp.ekosdk.internal.keycreator

import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentDataTypeFilter
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentSortOption

class CommentKeyCreator(
    private val referenceId: String,
    private val referenceType: String,
    private val parentId: String?,
    private val isDeleted: Boolean?,
    private val sortOption: AmityCommentSortOption,
    private val dataTypeFilter: AmityCommentDataTypeFilter?
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "referenceId" to referenceId,
            "referenceType" to referenceType,
            "parentId" to (parentId ?: ""),
            "isDeleted" to (isDeleted ?: false),
            "sortOption" to sortOption.apiKey
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            referenceId = referenceId,
            referenceType = referenceType,
            parentId = parentId,
            isDeleted = isDeleted,
            dataTypeFilter = dataTypeFilter
        )
    }

    private fun getConditionStatement(
        referenceId: String,
        referenceType: String,
        parentId: String?,
        isDeleted: Boolean?,
        dataTypeFilter: AmityCommentDataTypeFilter?
    ): String {
        //reference filter
        val referenceFilterStatement = "comment.referenceType = '$referenceType'" +
                " and comment.referenceId = '$referenceId'"
        //isDeleted filter
        var isDeletedFilterStatement = ""
        if (isDeleted == false) {
            isDeletedFilterStatement = " and comment.isDeleted = 0"
        } else if (isDeleted == true) {
            isDeletedFilterStatement = " and comment.isDeleted = 1"
        }
        //parent comment filter
        val parentCommentFilter = if (parentId == null) {
            " and comment.parentId is null"
        } else {
            " and comment.parentId = '$parentId'"
        }
        //attachment data type filter
        var attachmentDataTypeFilter = ""
        when (dataTypeFilter) {
            is AmityCommentDataTypeFilter.Any -> {
                attachmentDataTypeFilter += " and ("
                dataTypeFilter.dataTypes.forEachIndexed { index, dataType ->
                    attachmentDataTypeFilter += " comment.dataTypes like \"%${dataType.apiKey}%\""
                    if (index != dataTypeFilter.dataTypes.lastIndex) {
                        attachmentDataTypeFilter += " or "
                    }
                }
                attachmentDataTypeFilter += " )"
            }
            is AmityCommentDataTypeFilter.Exact -> {
                attachmentDataTypeFilter += " and ("
                dataTypeFilter.dataTypes.forEachIndexed { index, dataType ->
                    attachmentDataTypeFilter += " comment.dataTypes like \"%${dataType.apiKey}%\""
                    if (index != dataTypeFilter.dataTypes.lastIndex) {
                        attachmentDataTypeFilter += " and "
                    }
                }
                attachmentDataTypeFilter += " )"
            }
            null -> {}
        }

        //compose all condition
        return referenceFilterStatement +
                isDeletedFilterStatement +
                parentCommentFilter +
                attachmentDataTypeFilter
    }
}