package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Insert;
import androidx.room.OnConflictStrategy;

import com.ekoapp.ekosdk.PermissionEkoObject;
import com.ekoapp.ekosdk.internal.data.model.EkoPermissionObject;
import com.google.common.collect.FluentIterable;

import java.util.List;

public abstract class EkoPermissionDao<EntityType extends EkoPermissionObject> {

    static <PermissionObject extends PermissionEkoObject, PermissionFactoryObject extends EkoPermissionObject> void update(
            List<PermissionObject> ekoObjects,
            EkoPermissionDao<PermissionFactoryObject> dao,
            EkoPermissionObject.EkoPermissionFactory<PermissionFactoryObject> factory) {

        for (PermissionObject ekoObject : ekoObjects) {
            update(ekoObject, dao, factory);
        }
    }

    static <PermissionFactoryObject extends EkoPermissionObject> void update(
            PermissionEkoObject ekoObject,
            EkoPermissionDao<PermissionFactoryObject> dao,
            EkoPermissionObject.EkoPermissionFactory<PermissionFactoryObject> factory) {

        String[] permissions = ekoObject.getPermissions().toArray(new String[0]);

        List<PermissionFactoryObject> list = FluentIterable.from(permissions)
                .transform(permission -> factory.create(ekoObject.getReferencePermissionId(), ekoObject.getUserId(), permission))
                .toList();

        dao.insert(list);
        dao.retainAll(ekoObject.getReferencePermissionId(), ekoObject.getUserId(), permissions);
    }

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract void insert(List<EntityType> objects);

    abstract void retainAll(String id, String userId, String[] permissions);
}
