package com.amity.socialcloud.sdk.social.domain.community.moderation

import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipRepository
import com.ekoapp.ekosdk.internal.constants.COMMUNITY_ID
import com.ekoapp.ekosdk.internal.constants.USER_ID
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import io.reactivex.rxjava3.core.Completable

internal class UnBanUsersCommunityUseCase {
    fun execute(communityId: String, userIds: List<String>): Completable {
        EkoPreconditions.checkValidParameter(communityId, COMMUNITY_ID)
        EkoPreconditions.checkValidParameter(userIds, USER_ID)
        return CommunityMembershipRepository().unbanUsers(communityId, userIds)
    }
}