package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.dto.social.story.StoryQueryDto
import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.social.data.story.StoryEventPersister
import com.amity.socialcloud.sdk.social.data.story.StoryLocalDataStore
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass


internal abstract class StoryEventListner: MqttEventListener<StoryQueryDto>() {

    override val type: KClass<StoryQueryDto>
        get() = StoryQueryDto::class

    override fun processEvent(dto: StoryQueryDto) {
        StoryEventPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()
    }

    override fun shouldProcessEvent(dto: StoryQueryDto): Boolean {
        var shouldProcessEvent = false
        val storyId = dto.stories?.first()?.storyId
        storyId?.let {
            shouldProcessEvent = StoryLocalDataStore().hasInLocal(it)
        }
        return shouldProcessEvent
    }

}