package com.amity.socialcloud.sdk.social.data.comment.flag

import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity
import io.reactivex.rxjava3.core.Completable

internal class CommentFlagLocalDataStore {

    fun saveFlags(flags: List<EkoCommentFlagEntity>): Completable {
        return Completable.fromAction {
            val dao = UserDatabase.get().commentFlagDao()
            flags.forEach {
                dao.getByIdNow(it.commentId)?.let { flag ->
                    it.localFlag = flag.localFlag
                }
            }
            dao.save(flags)
        }
    }

}