package com.amity.socialcloud.sdk.video.domain.stream

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.video.domain.moderation.StreamModerationGetUseCase

internal class StreamComposerUseCase : ComposerUseCase() {

    fun execute(stream: AmityStream): AmityStream {
        addModeration(stream)
        addCreator(stream)
        addThumbnail(stream)
        return stream
    }

    private fun addCreator(stream: AmityStream) {
        stream.user = UserGetUseCase().execute(stream.getCreatorId())
    }

    private fun addThumbnail(stream: AmityStream) {
        stream.thumbnailId?.let {
            stream.thumbnailImage = ImageGetUseCase().execute(it)
        }
    }

    private fun addModeration(stream: AmityStream) {
        stream.moderation = StreamModerationGetUseCase().execute(stream.moderationId)
    }

}