package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.socket.util.EkoGson.get
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap
import com.google.gson.reflect.TypeToken

class EkoReactionMapConverter {
	@TypeConverter
	fun stringToStringIntMap(json: String): AmityReactionMap {
		return get().fromJson(json, object : TypeToken<AmityReactionMap?>() {}.type)
	}
	
	@TypeConverter
	fun stringIntMapToString(map: AmityReactionMap): String {
		return get().toJson(map)
	}
}