package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.socket.util.EkoGson
import com.google.gson.JsonObject
import kotlin.reflect.KClass

internal abstract class MqttEventListener<X : Any> {

    internal val TAG = MqttEventListener::class.java.simpleName

    abstract fun getEventName() : String

    abstract val type : KClass<X>


    internal fun  onEvent(json: JsonObject) {
        val dto = EkoGson.get().fromJson(json, type.java)
        if(shouldProcessEvent(dto)) {
            processEvent(dto)
        }
    }

    internal abstract fun processEvent(dto: X)

    internal open fun shouldProcessEvent(dto: X) : Boolean {
        return false
    }

}