/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;

@Entity(tableName="socket_url")
public class EkoSocketUrl {
    private static final String SINGLETON_SOCKET_URL_ID = "SINGLETON_SOCKET_URL_ID";
    @PrimaryKey
    @NonNull
    private String id = EkoSocketUrl.currentSocketUrlId();
    private String socketUrl;
    private long updateAt = System.currentTimeMillis();

    public static String currentSocketUrlId() {
        return SINGLETON_SOCKET_URL_ID;
    }

    @NonNull
    public String getId() {
        return EkoSocketUrl.currentSocketUrlId();
    }

    public void setId(String id) {
        this.id = EkoSocketUrl.currentSocketUrlId();
    }

    @NonNull
    public String getSocketUrl() {
        return this.socketUrl;
    }

    public void setSocketUrl(@NonNull String httpUrl) {
        this.socketUrl = EkoPreconditions.checkValidId(httpUrl, "socketUrl");
    }

    public long getUpdateAt() {
        return this.updateAt;
    }

    public void setUpdateAt(long updateAt) {
        this.updateAt = updateAt;
    }

    public static EkoSocketUrl create(@NonNull String url) {
        EkoSocketUrl ekoSocketUrl = new EkoSocketUrl();
        ekoSocketUrl.setSocketUrl(url);
        return ekoSocketUrl;
    }
}

