package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Insert;
import androidx.room.OnConflictStrategy;

import com.ekoapp.ekosdk.RoleEkoObject;
import com.ekoapp.ekosdk.internal.data.model.EkoRoleObject;
import com.google.common.collect.FluentIterable;

import java.util.List;

public abstract class EkoRoleDao<EntityType extends EkoRoleObject> {

    static <RoleObject extends RoleEkoObject, RoleFactoryObject extends EkoRoleObject> void update(
            List<RoleObject> ekoObjects,
            EkoRoleDao<RoleFactoryObject> dao,
            EkoRoleObject.EkoRoleFactory<RoleFactoryObject> factory) {

        for (RoleObject ekoObject : ekoObjects) {
            update(ekoObject, dao, factory);
        }
    }

    static <RoleFactoryObject extends EkoRoleObject> void update(
            RoleEkoObject ekoObject,
            EkoRoleDao<RoleFactoryObject> dao,
            EkoRoleObject.EkoRoleFactory<RoleFactoryObject> factory) {

        String[] roles = ekoObject.getRoles().toArray(new String[0]);

        List<RoleFactoryObject> list = FluentIterable.from(roles)
                .transform(role -> factory.create(ekoObject.getReferenceRoleId(), ekoObject.getUserId(), role))
                .toList();

        dao.insert(list);
        dao.retainAll(ekoObject.getReferenceRoleId(), ekoObject.getUserId(), roles);
    }

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract void insert(List<EntityType> objects);

    abstract void retainAll(String id, String userId, String[] roles);
}
