package com.amity.socialcloud.sdk.core.data.ad

import com.amity.socialcloud.sdk.entity.core.ad.AdEntity
import com.amity.socialcloud.sdk.entity.core.ad.AdsSettingsEntity
import com.amity.socialcloud.sdk.entity.core.ad.AdvertiserEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable

internal class AdLocalDataStore {

    fun deleteAllAds(): Completable {
        return Completable.fromAction { UserDatabase.get().adDao().deleteAll() }
    }

    fun saveAds(ads: List<AdEntity>): Completable {
        return Completable.fromAction { UserDatabase.get().adDao().save(ads) }
    }

    fun saveAdvertisers(advertisers: List<AdvertiserEntity>): Completable {
        return Completable.fromAction { UserDatabase.get().advertiserDao().save(advertisers) }
    }

    fun saveAdsSettings(settings: AdsSettingsEntity): Completable {
        return Completable.fromAction { UserDatabase.get().adsSettingsDao().save(listOf(settings)) }
    }

    fun getAllAds(): List<AdEntity> {
        return UserDatabase.get().adDao().getAllNow()
    }

    fun getAdvertiser(advertiserId: String): AdvertiserEntity? {
        return UserDatabase.get().advertiserDao().getByIdNow(advertiserId)
    }

    fun getSettings(): AdsSettingsEntity? {
        return UserDatabase.get().adsSettingsDao().getNow()
    }

}