package com.amity.socialcloud.sdk.chat.data.marker.sync

import com.ekoapp.ekosdk.internal.api.dto.UserMarkerDto
import io.reactivex.rxjava3.core.Single
import org.joda.time.DateTime

class MarkerSyncRepository {
	
	fun syncMarkers(deviceLastSyncAt: DateTime?): Single<Pair<List<UserMarkerDto>,Boolean>> {
		return MarkerSyncRemoteDataStore().syncMarkers(deviceLastSyncAt)
			.flatMap {
				MarkerSyncPersister().persist(it)
					.onErrorComplete()
					.andThen(
						Single.just(
							Pair(it.userMarkers,it.subChannelMarkers.isNotEmpty())
						)
					)
			}
	}
	
}