package com.amity.socialcloud.sdk.chat.data.marker.readreceipt

import com.ekoapp.ekosdk.internal.ReadReceiptEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable

internal class ReadReceiptLocalDataStore {
    
    fun getReadReceipt(subChannelId: String): ReadReceiptEntity? {
        return UserDatabase.get().readReceiptDao().getByIdNow(subChannelId)
    }
    
    fun saveReadReceipts(
        readReceipts: List<ReadReceiptEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().readReceiptDao().save(readReceipts)
        }
    }
    
    fun updateLatestSegment(subChannelId: String, segment: Int) {
        UserDatabase.get().readReceiptDao().updateLatestSegment(subChannelId, segment)
    }
    
    fun updateLatestSyncSegment(subChannelId: String, segment: Int) {
        UserDatabase.get().readReceiptDao().updateLatestSyncSegment(subChannelId, segment)
    }
    
    fun deleteReadReceipt(subChannelId: String) {
        UserDatabase.get().readReceiptDao().deleteBySubChannelId(subChannelId)
    }
    
    fun getUnsyncReadReceipt(): List<ReadReceiptEntity> {
        return UserDatabase.get().readReceiptDao().getUnsyncReadReceipts()
    }

}