package com.amity.socialcloud.sdk.api.core.user.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSortOption
import com.ekoapp.ekosdk.internal.usecase.user.GetUserPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityUserQuery private constructor(
    private val sortOption: AmityUserSortOption,
    private val keyword: String?
) {

    fun query(): Flowable<PagingData<AmityUser>> {
        return GetUserPagingDataUseCase().execute(keyword = keyword, sortBy = sortOption)
    }

    class Builder internal constructor() {

        private var sortOption: AmityUserSortOption = AmityUserSortOption.DISPLAYNAME
        private var keyword: String? = null

        fun sortBy(sortOption: AmityUserSortOption): Builder {
            this.sortOption = sortOption
            return this
        }

        fun build(): AmityUserQuery {
            return AmityUserQuery(sortOption, keyword)
        }
    }

}