package com.amity.socialcloud.sdk.social.data.post

import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.CreatePostV4Request
import com.ekoapp.ekosdk.internal.api.socket.request.PostUpdateRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface PostApi {

    @POST("api/v4/posts")
    fun createPost(
        @Body request: CreatePostV4Request
    ): Single<EkoPostQueryDto>

    @GET("api/v4/posts")
    fun queryPosts(
        @Query("targetType") targetType: String? = null,
        @Query("targetId") targetId: String? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("isDeleted") isDeleted: Boolean? = null,
        @Query("feedType") feedType: List<String>? = null,
        @Query("dataTypes") dataTypes: List<String>? = null,
        @Query("matchingOnlyParentPost") matchingOnlyParentPost: Boolean? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<EkoPostQueryDto>

    @GET("api/v3/posts/{postId}")
    fun getPost(
        @Path("postId") postId: String? = null
    ): Single<EkoPostQueryDto>

    @GET("api/v3/posts/list")
    fun getPostByIds(
        @Query("postIds[]") postIds: List<String>
    ): Single<EkoPostQueryDto>

    @GET("api/v3/posts/{postId}/isflagbyme")
    fun isFlaggedByMe(
        @Path("postId") postId: String? = null
    ): Single<JsonObject>

    @DELETE("api/v4/posts/{postId}")
    fun deletePost(
        @Path("postId") postId: String? = null,
        @Query("permanent") permanent: Boolean? = null
    ): Single<EkoDeletionDto>

    @PUT("api/v4/posts/{postId}")
    fun updatePost(
        @Path("postId") postId: String? = null,
        @Body request: PostUpdateRequest? = null
    ): Single<EkoPostQueryDto>

    @POST("api/v3/posts/{postId}/flag")
    fun flagPost(
        @Path("postId") postId: String? = null
    ): Single<EkoPostQueryDto>

    @DELETE("api/v3/posts/{postId}/unflag")
    fun unflagPost(
        @Path("postId") postId: String? = null
    ): Single<EkoPostQueryDto>

    @POST("api/v3/posts/{postId}/approve")
    fun approvePost(
        @Path("postId") postId: String? = null
    ): Single<EkoPostQueryDto>

    @POST("api/v3/posts/{postId}/decline")
    fun declinePost(
        @Path("postId") postId: String? = null
    ): Single<EkoPostQueryDto>

    @GET("api/v4/me/global-feeds")
    fun globalFeedV4(
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<EkoPostQueryDto>

    @GET("api/v5/me/global-feeds")
    fun globalFeedV5(
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<EkoPostQueryDto>

    @GET("api/v1/semantic-search/posts")
    fun searchPosts(
        @Query("query") query: String,
        @Query("targetType") targetType: String? = null,
        @Query("targetId") targetId: String? = null,
        @Query("dataTypes") dataTypes: List<String>?,
        @Query("matchingOnlyParentPost") matchingOnlyParentPost: Boolean,
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<EkoPostQueryDto>

}