package com.amity.socialcloud.sdk.api.chat.channel.query

import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.common.collect.Sets

class AmityConversationChannelQuery private constructor(isDeleted: Boolean?,
                                                        includingTags: AmityTags,
                                                        excludingTags: AmityTags
)
    : AmityChannelQuery(isDeleted,
        Sets.newHashSet(AmityChannel.Type.CONVERSATION),
        AmityChannelFilter.MEMBER,
        includingTags,
        excludingTags) {

    class Builder internal constructor() {
        private var isDeleted: Boolean? = null
        private var includingTags = AmityTags()
        private var excludingTags = AmityTags()

        fun includingTags(includingTags: AmityTags): Builder {
            this.includingTags = includingTags
            return this
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            this.excludingTags = excludingTags
            return this
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            return apply {
                this.isDeleted = if(includeDeleted) null else false
            }
        }

        fun build(): AmityConversationChannelQuery {
            return AmityConversationChannelQuery(isDeleted, includingTags, excludingTags)
        }
    }

}