package com.ekoapp.ekosdk.internal.init

import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.core.session.eventbus.NetworkConnectionEventPublisher
import com.amity.socialcloud.sdk.push.EkoPushContractWrapper
import com.ekoapp.ekosdk.internal.api.http.AmityUploadService
import com.ekoapp.ekosdk.internal.data.EkoDatabase
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.push.EkoPushContractImpl
import com.ekoapp.ekosdk.internal.util.AppContext
import com.ekoapp.ekosdk.internal.util.RxEko
import com.ekoapp.ekosdk.sdk.R
import com.google.common.eventbus.EventBus
import io.reactivex.plugins.RxJavaPlugins

object AmityCoreSDKInitializer {


    @Synchronized
    fun init(context: Context) {
        AppContext.init(context)
        initRxJavaPlugins()
        listenToTimeZoneChanges(context)
        initEventPublisher(context)
        applyBuildConfig(context)
    }

    private fun listenToTimeZoneChanges(context: Context) {
        context.applicationContext
            .registerReceiver(
                TimeZoneChangedReceiver(),
                IntentFilter(Intent.ACTION_TIMEZONE_CHANGED)
            )
    }

    private fun initRxJavaPlugins() {
        val defaultErrorHandler = RxJavaPlugins.getErrorHandler()
        io.reactivex.rxjava3.plugins.RxJavaPlugins
            .setErrorHandler { t: Throwable ->
                defaultErrorHandler?.accept(t)
                RxEko.LOG_ERROR_CONSUMER.accept(t)
            }
        RxJavaPlugins.setErrorHandler { t: Throwable ->
            defaultErrorHandler?.accept(t)
            RxEko.LOG_ERROR_CONSUMER.accept(t)
        }
    }

    internal fun initApiService() {
        EkoPushContractWrapper.init(EkoPushContractImpl())
        AmityUploadService.initService()
    }
    
    private fun initEventPublisher(context: Context) {
        NetworkConnectionEventPublisher.initPublisher(context)
    }
    
    private fun applyBuildConfig(context: Context) {
        val grant100Channel = context.applicationContext?.resources?.getBoolean(R.bool.AMITY_KTB_CHANNEL_GRANT_100) ?: false
        if (grant100Channel) {
            ChannelRepository.DEFAULT_PAGE_SIZE = 100
        }
    }

}