package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "user_follow_count")
class EkoFollowCountEntity(@PrimaryKey var userId: String = ObjectId.get().toHexString(),
                           var followerCount: Int? = 0,
                           var followingCount: Int? = 0,
                           var pendingCount: Int? = 0) : EkoObject() {

    override fun getId(): String {
        return userId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? EkoFollowCountEntity)?.let { followCount ->
            (Objects.equal(userId, followCount.userId))
                    && (Objects.equal(followerCount, followCount.followerCount))
                    && (Objects.equal(followingCount, followCount.followingCount))
                    && (Objects.equal(pendingCount, followCount.pendingCount))
        } ?: kotlin.run {
            false
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(userId, followerCount, followingCount, pendingCount)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("userId", userId)
            add("followerCount", followerCount)
            add("followingCount", followingCount)
            add("pendingCount", pendingCount)
        }
        return super.internalToString(toStringHelper)
    }
}