package com.ekoapp.ekosdk.internal.api.event

import com.amity.socialcloud.sdk.dto.video.EkoStreamListDto
import com.amity.socialcloud.sdk.socket.util.EkoGson
import com.amity.socialcloud.sdk.video.data.stream.StreamQueryPersister
import io.reactivex.rxjava3.schedulers.Schedulers


class StreamDidFlagListener : SocketEventListener() {

    override val event: String = "v3.video-streaming.didFlag"

    override fun onEvent(event: String, vararg args: Any) {
        super.onEvent(event, *args)
        val json = args[0].toString()
        updateStreamListData(json)
    }

    private fun updateStreamListData(json: String) {
        val dto = EkoGson.get().fromJson(json, EkoStreamListDto::class.java)
        StreamQueryPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                it.printStackTrace()
            }
            .subscribe()
    }
}