package com.amity.socialcloud.sdk.video.domain.stream

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.video.data.stream.StreamRepository
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class StreamQueryPagingDataUseCase {

    fun execute(statuses: Array<AmityStream.Status>): Flowable<PagingData<AmityStream>> {
        return StreamRepository().getStreamCollectionPagingData(statuses)
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) {
                    StreamComposerUseCase().execute(it)
                }
            }
    }
}