package com.amity.socialcloud.sdk.api.core.permission

import com.amity.socialcloud.sdk.model.core.permission.AmityPermission
import com.ekoapp.ekosdk.internal.usecase.permission.CommunityPermissionValidatorUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityCommunityPermissionValidator internal constructor(
    private val permission: AmityPermission,
    private val communityId: String
) {

    fun check(): Flowable<Boolean> {
        return CommunityPermissionValidatorUseCase().execute(
            permission = permission,
            communityId = communityId
        )
    }

}