package com.ekoapp.ekosdk.internal.data;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.Room;
import androidx.room.RoomDatabase;

import net.sqlcipher.database.SupportFactory;

public final class RoomUtil {

    public static <T extends RoomDatabase> RoomDatabase.Builder<T> databaseBuilder(
            @NonNull Context context,
            @NonNull Class<T> klass,
            @NonNull String name,
            @Nullable byte[] passphrase
    ) {
        RoomDatabase.Builder<T> builder = Room.databaseBuilder(context, klass, name)
                .fallbackToDestructiveMigration();

        if(passphrase != null) {
            builder.openHelperFactory(new SupportFactory(passphrase, null, false));
        }
        return builder;
    }

    private RoomUtil() { /* NO INSTANCE */ }
}
