package com.amity.socialcloud.sdk.video.domain.stream

import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.video.data.stream.StreamRepository
import io.reactivex.rxjava3.core.Flowable

internal class GetStreamUseCase {

    fun execute(streamId: String): Flowable<AmityStream> {
        return if (streamId.isEmpty()) {
            Flowable.error(
                AmityException.create(
                    "stream not found",
                    null,
                    AmityError.ITEM_NOT_FOUND
                )
            )
        } else {
            StreamRepository().observeStream(streamId)
                .map {
                    StreamComposerUseCase().execute(it)
                }
        }
    }
}