package com.ekoapp.ekosdk.internal.api.http

import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.sdk.BuildConfig
import okhttp3.Interceptor
import okhttp3.Response
import okhttp3.logging.HttpLoggingInterceptor
import java.io.IOException

internal class AmityLoggingInterceptor : Interceptor {
    private val timberLogger = HttpLoggingInterceptor.Logger { msg: String? ->
        val TAG = "OkHttp"
        val log = AmityLog.tag(TAG)
        if (BuildConfig.DEBUG) {
            log.e(msg)
        } else {
            log.i(msg)
        }
    }
    private val okhttpLogger = HttpLoggingInterceptor(timberLogger)
            .setLevel(if (BuildConfig.DEBUG) HttpLoggingInterceptor.Level.BODY else HttpLoggingInterceptor.Level.NONE)

    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        return okhttpLogger.intercept(chain)
    }
}
