package com.amity.socialcloud.sdk.chat.data.marker.subchannel

import com.amity.socialcloud.sdk.chat.data.marker.channel.ChannelMarkerLocalDataStore
import com.ekoapp.ekosdk.internal.ChannelUnreadInfoEntity
import com.ekoapp.ekosdk.internal.SubChannelMarkerEntity
import com.ekoapp.ekosdk.internal.SubChannelUnreadInfoEntity
import com.ekoapp.ekosdk.internal.UserSubChannelMarkerEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import org.joda.time.DateTime

internal class SubChannelMarkerLocalDataStore {
    
    fun getSubChannelMarker(subChannelId: String): SubChannelMarkerEntity? {
        return UserDatabase.get().subChannelMarkerDao().getByIdNow(subChannelId)
    }
    
    fun saveSubChannelMarkers(
        subChannelMarkers: List<SubChannelMarkerEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().subChannelMarkerDao().save(subChannelMarkers)
        }
    }
    
    fun getSubChannelUnreadInfo(subChannelId: String): SubChannelUnreadInfoEntity? {
        return UserDatabase.get().subChannelUnreadInfoDao().getByIdNow(subChannelId)
    }
    
    fun saveSubChannelUnreadInfo(
        subChannelUnreadInfo: List<SubChannelUnreadInfoEntity>,
    ) {
        UserDatabase.get().subChannelUnreadInfoDao().save(subChannelUnreadInfo)
    }
    
    fun getUserSubChannelMarker(subChannelId: String): UserSubChannelMarkerEntity? {
        return UserDatabase.get().userSubChannelMarkerDao().getByIdNow(subChannelId)
    }
    
    fun saveUserSubChannelMarkers(
        userSubChannelMarkers: List<UserSubChannelMarkerEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().userSubChannelMarkerDao().save(userSubChannelMarkers)
        }
    }
    
    fun updateReadToSegment(subChannelId: String, segment: Int) {
        UserDatabase.get().userSubChannelMarkerDao().updateReadToSegment(subChannelId, segment)
    }
    
    fun deleteSubChannelByChannelId(channelId: String) {
        UserDatabase.get().userSubChannelMarkerDao().deleteByChannelId(channelId)
    }
    
    fun deleteUnreadInfoBySubChannelId(subChannelId: String) {
        UserDatabase.get().subChannelUnreadInfoDao().deleteById(subChannelId)
    }
    
    fun deleteUnreadInfoByChannelId(channelId: String) {
        UserDatabase.get().subChannelUnreadInfoDao().deleteByChannelId(channelId)
    }
    
    fun getDeletedSubChannelIds(subChannelIds: List<String>): List<String> {
        return UserDatabase.get().subChannelUnreadInfoDao().getDeletedIds(subChannelIds)
    }

}