package com.amity.socialcloud.sdk.chat.domain.channel

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import io.reactivex.rxjava3.core.Flowable

internal class JoinedChannelsGetUseCase {

    fun execute() : Flowable<List<AmityChannel>> {
        return ChannelRepository().getAllJoinedChannels()
            .map {
                it.map {
                    ChannelComposerUseCase().execute(it)
                }
            }
    }

}