package com.amity.socialcloud.sdk.api.social.comment.latest

import com.amity.socialcloud.sdk.model.social.comment.CommentType

class AmityLatestCommentQueryType internal constructor() {

    /**
     * Specifies the post that the comments were created on
     * @param [postId] a postId of a post
     * @return new instance of AmityLatestCommentQuery.Builder
     */
    fun post(postId: String): AmityLatestCommentQuery.Builder {
        return AmityLatestCommentQuery.Builder()
                .referenceType(CommentType.POST.value)
                .referenceId(postId)
    }

    /**
     * Specifies the content that the comments were created on
     * @param [contentId] a contentId
     * @return new instance of AmityLatestCommentQuery.Builder
     */
    fun content(contentId: String): AmityLatestCommentQuery.Builder {
        return AmityLatestCommentQuery.Builder()
                .referenceType(CommentType.CONTENT.value)
                .referenceId(contentId)
    }

}