package com.ekoapp.ekosdk.internal.repository.user.helper

import androidx.annotation.WorkerThread
import com.amity.socialcloud.sdk.core.data.user.UserModelMapper
import com.amity.socialcloud.sdk.core.domain.user.UserComposerUseCase
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowRelationship
import com.amity.socialcloud.sdk.model.core.follow.AmityUserFollowInfo
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity
import com.ekoapp.ekosdk.internal.mapper.EkoUserFollowStatusMapper

internal class UserRepositoryHelper {

    @Deprecated("To move mapping to where it belongs")
    @WorkerThread
    fun attachDataAndMapToExternal(entity: UserEntity): AmityUser {
        return UserComposerUseCase().execute(UserModelMapper().map(entity))
    }

    @WorkerThread
    private fun mapToExternalModel(entity: EkoUserFollowStatusEntity): AmityFollowRelationship {
        return EkoUserFollowStatusMapper().map(entity)
    }

    fun attachDataAndMapToExternal(entity: EkoUserFollowStatusEntity): AmityFollowRelationship {
        return mapToExternalModel(entity)
    }

    fun attachUserFollowInfoDataAndMapToExternal(followRelationship: AmityFollowRelationship,
                                                 followCountEntity: EkoFollowCountEntity): AmityUserFollowInfo {

        return AmityUserFollowInfo(followRelationship.getStatus(),
                followCountEntity.followingCount ?: 0,
                followCountEntity.followerCount ?: 0)
    }
}