package com.amity.socialcloud.sdk.video.data.moderation

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.video.stream.StreamModerationEntity
import com.amity.socialcloud.sdk.model.video.stream.AmityStreamModeration
import com.amity.socialcloud.sdk.model.video.stream.AmityStreamModerationLabel
import com.google.gson.JsonArray
import org.joda.time.DateTime


internal class StreamModerationModelMapper : ModelMapper<StreamModerationEntity, AmityStreamModeration>() {

    override fun map(entity: StreamModerationEntity): AmityStreamModeration {
        return AmityStreamModeration(
            moderationId = entity.moderationId,
            streamId = entity.streamId,
            flagLabels = convertToLabels(entity.flagLabels),
            terminateLabels = convertToLabels(entity.terminateLabels),
            createdAt = entity.createdAt,
            updatedAt = entity.updatedAt
        )
    }

    private fun convertToLabels(labels: JsonArray?): List<AmityStreamModerationLabel> {
        return labels?.map {
            val json = it.asJsonObject
            AmityStreamModerationLabel(
                category = json.get("category").asString,
                detectedAt = DateTime(json.get("detected").asString)
            )
        } ?: emptyList()
    }

}