package com.amity.socialcloud.sdk.social.data.community.membership

import com.ekoapp.ekosdk.internal.api.dto.CommunityListQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.*
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface CommunityMembershipApi {

    @GET("api/v3/communities/{communityId}/users")
    fun queryCommunityUsers(
        @Path("communityId") communityId: String,
        @Query("search") keyword: String? = null,
        @Query("roles[]") roles: List<String>? = null,
        @Query("memberships[]") memberships: List<String>? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null
    ): Single<CommunityListQueryDto>

    @POST("api/v3/communities/{communityId}/users")
    fun addCommunityUsers(
        @Path("communityId") communityId: String,
        @Body request: CommunityAddUsersRequest,
    ): Single<CommunityListQueryDto>

    @HTTP(method = "DELETE", path ="api/v3/communities/{communityId}/users", hasBody = true)
    fun deleteCommunityUsers(
        @Path("communityId") communityId: String,
        @Body request: CommunityRemoveUsersRequest,
    ): Single<CommunityListQueryDto>


    @POST("api/v4/communities/{communityId}/users/roles")
    fun addCommunityRoles(
        @Path("communityId") communityId: String,
        @Body request: CommunityAddRolesRequest,
    ): Single<CommunityListQueryDto>

    @HTTP(method = "DELETE", path ="api/v4/communities/{communityId}/users/roles", hasBody = true)
    fun deleteCommunityRoles(
        @Path("communityId") communityId: String,
        @Body request: CommunityRemoveRolesRequest,
    ): Single<CommunityListQueryDto>

    @PUT("api/v3/communities/{communityId}/users/ban")
    fun banCommunityUsers(
        @Path("communityId") communityId: String,
        @Body request: CommunityBanUsersRequest,
    ): Single<CommunityListQueryDto>

    @PUT("api/v3/communities/{communityId}/users/unban")
    fun unbanCommunityUsers(
        @Path("communityId") communityId: String,
        @Body request: CommunityUnBanUsersRequest,
    ): Single<CommunityListQueryDto>

}