package com.amity.socialcloud.sdk.model.video.stream

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.ekoapp.ekosdk.JsonArrayParceler
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime


@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
@TypeParceler<JsonArray?, JsonArrayParceler>
data class AmityStreamModeration internal constructor(
    private val moderationId: String,
    private val streamId: String,
    internal var flagLabels: List<AmityStreamModerationLabel>,
    internal var terminateLabels: List<AmityStreamModerationLabel>,
    private val createdAt: DateTime,
    private val updatedAt: DateTime
) : Parcelable {

    fun getModerationId(): String {
        return moderationId
    }
    fun getStreamId(): String {
        return streamId
    }

    fun getFlagLabels(): List<AmityStreamModerationLabel> {
        return flagLabels
    }

    fun getTerminateLabels(): List<AmityStreamModerationLabel> {
        return terminateLabels
    }
    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

}