package com.amity.socialcloud.sdk.model.video.stream

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.JsonArrayParceler
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
@TypeParceler<JsonArray?, JsonArrayParceler>
data class AmityStream internal constructor(private val streamId: String,
                                            internal val moderationId: String,
                                            internal var moderation: AmityStreamModeration? = null,
                                            private val status: Status = Status.IDLE,
                                            private val title: String?,
                                            private val description: String?,
                                            private val resolution: String?,
                                            internal val thumbnailId: String?,
                                            internal var thumbnailImage: AmityImage? = null,
                                            internal val watcherData: JsonObject?,
                                            private val broadcasterData: JsonObject?,
                                            internal val recordings: JsonArray?,
                                            private val userId: String,
                                            internal var user: AmityUser? = null,
                                            private val metadata: JsonObject?,
                                            private val isDeleted: Boolean,
                                            private val createdAt: DateTime,
                                            private val updatedAt: DateTime) : Parcelable, ReactorObject {

    fun getStreamId(): String {
        return streamId
    }

    fun getStatus(): Status {
        return status
    }

    fun getTitle(): String? {
        return title
    }

    fun getDescription(): String? {
        return description
    }

    fun getResolution(): String? {
        return resolution
    }

    fun getCreatorId(): String {
        return userId
    }

    fun getCreator(): AmityUser? {
        return user
    }

    fun getThumbnailImage(): AmityImage? {
        return thumbnailImage
    }

    fun getMetaData(): JsonObject? {
        return metadata
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    fun isDeleted(): Boolean {
        return isDeleted
    }


    // FIXME: Consider moving this operation to where it's required
    internal fun getSerializedWatcherData(): AmityWatcherData? {
        watcherData?.let {
            return AmityWatcherData(watcherData)
        } ?: kotlin.run {
            return null
        }
    }

    fun getBroadcasterData(): AmityBroadcasterData? {
        broadcasterData?.let {
            return AmityBroadcasterData(broadcasterData)
        } ?: kotlin.run {
            return null
        }
    }

    private fun getStreamModeration(): AmityStreamModeration? {
        return moderation
    }

    // FIXME: Consider moving this operation to where it's required
    internal fun getSerializedRecordings(): List<AmityRecordingData?> {
        recordings?.let {
            val recordingDataList = arrayListOf<AmityRecordingData>()
            it.forEach { jsonElement ->
                if (jsonElement is JsonObject) {
                    recordingDataList.add(AmityRecordingData(jsonElement))
                }
            }
            return recordingDataList
        } ?: kotlin.run {
            return listOf()
        }
    }

    enum class Status(val apiKey: String) {
        IDLE("idle"),
        LIVE("live"),
        ENDED("ended"),
        RECORDED("recorded");

        companion object {
            fun enumOf(value: String?): Status {
                return values().find { it.apiKey == value } ?: IDLE
            }
        }
    }
    
    override fun updatedAt(): DateTime {
        return updatedAt
    }
    
    override fun uniqueId(): String {
        return streamId
    }

}