package com.amity.socialcloud.sdk.core.data.analytics

import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.engine.analytics.capturer.ClickStoryEventCapturer
import com.amity.socialcloud.sdk.core.engine.analytics.capturer.ViewPostEventCapturer
import com.amity.socialcloud.sdk.core.engine.analytics.capturer.ViewStoryEventCapturer

internal class AnalyticsService {

    fun markPostAsViewed(postId: String) {
        CoreClient.getAnalyticsEngine()?.getCapturerInstance(ViewPostEventCapturer::class)?.captureEvent(postId)
    }

    fun markStoryAsViewed(storyId: String) {
        CoreClient.getAnalyticsEngine()?.getCapturerInstance(ViewStoryEventCapturer::class)?.captureEvent(storyId)
    }

    fun markStoryAsClicked(storyId: String) {
        CoreClient.getAnalyticsEngine()?.getCapturerInstance(ClickStoryEventCapturer::class)?.captureEvent(storyId)
    }

}