package com.amity.socialcloud.sdk.chat.data.message.reaction

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity


internal class MessageReactionEntityMapper : EntityMapper<EkoMessageDto, EkoReactionEntity>() {

    override fun map(list: List<EkoMessageDto>): List<EkoReactionEntity> {
        val reactions = mutableListOf<EkoReactionEntity>()
        list.forEach {
            val reactionNames = it.myReactions?.map { reactionName ->
                ReactionRepository().createMyReaction(
                    AmityReactionReferenceType.MESSAGE,
                    it.messageId,
                    reactionName!!
                )
            }
            reactionNames?.let {
                reactions.addAll(it)
            }
        }
        return reactions
    }

}