/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.api.core.encryption.AmityDBEncryption;
import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint;
import com.amity.socialcloud.sdk.api.core.events.AmityTopicSubscription;
import com.amity.socialcloud.sdk.api.core.file.AmityFileRepository;
import com.amity.socialcloud.sdk.api.core.notification.AmityNotification;
import com.amity.socialcloud.sdk.api.core.permission.AmityPermissionValidator;
import com.amity.socialcloud.sdk.api.core.presence.AmityPresenceService;
import com.amity.socialcloud.sdk.api.core.presence.AmityUserPresenceRepository;
import com.amity.socialcloud.sdk.api.core.reaction.AmityReactionRepository;
import com.amity.socialcloud.sdk.api.core.session.AmitySessionEstablisher;
import com.amity.socialcloud.sdk.api.core.user.AmityUserRepository;
import com.amity.socialcloud.sdk.api.core.user.notification.AmityUserNotification;
import com.amity.socialcloud.sdk.api.core.user.update.AmityUserUpdate;
import com.amity.socialcloud.sdk.chat.data.marker.user.ObserveUserMarker;
import com.amity.socialcloud.sdk.chat.data.marker.user.UserUnreadModelMapper;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.MarkReadEngine;
import com.amity.socialcloud.sdk.core.MarkerSyncEngine;
import com.amity.socialcloud.sdk.core.MessagePreviewEngine;
import com.amity.socialcloud.sdk.core.MessageReadReceiptSyncEngine;
import com.amity.socialcloud.sdk.core.MessageSyncEngine;
import com.amity.socialcloud.sdk.core.ObjectResolverEngine;
import com.amity.socialcloud.sdk.core.domain.notification.RegisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterAllUsersForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.domain.session.LogoutUseCase;
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEngine;
import com.amity.socialcloud.sdk.core.presence.PresenceSyncEngine;
import com.amity.socialcloud.sdk.core.session.SessionError;
import com.amity.socialcloud.sdk.core.session.SessionStateManager;
import com.amity.socialcloud.sdk.core.session.component.DatabaseSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenWatcherSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.UserSettingSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessageAttachment;
import com.amity.socialcloud.sdk.model.core.content.AmityContentCheck;
import com.amity.socialcloud.sdk.model.core.events.AmityTopic;
import com.amity.socialcloud.sdk.model.core.permission.AmityPermission;
import com.amity.socialcloud.sdk.model.core.session.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.model.core.session.SessionHandler;
import com.amity.socialcloud.sdk.model.core.unread.UserUnread;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.streamapi.AmityClientConfiguration;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.amity.socialcloud.sdk.video.data.stream.StreamFunction;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.UserMarkerEntity;
import com.ekoapp.ekosdk.internal.api.AmityHttpClient;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl;
import com.ekoapp.ekosdk.internal.init.AmityCoreSDKInitializer;
import com.ekoapp.ekosdk.internal.init.EkoSdkInitProvider;
import com.ekoapp.ekosdk.internal.usecase.content.GetContentCheckUseCase;
import com.ekoapp.ekosdk.internal.util.AppContext;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.Objects;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableEmitter;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Function4;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.CompletableSubject;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00da\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JJ\u0016\u0010K\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HJ\u0006\u0010L\u001a\u00020MJ\u0006\u0010N\u001a\u00020DJ\u0006\u0010O\u001a\u00020\u0004J\b\u0010P\u001a\u0004\u0018\u00010\u0006J\u0006\u0010Q\u001a\u00020RJ\f\u0010S\u001a\b\u0012\u0004\u0012\u00020U0TJ\f\u0010V\u001a\b\u0012\u0004\u0012\u00020X0WJ\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020Z0WJ\r\u0010[\u001a\u00020\\H\u0000\u00a2\u0006\u0002\b]J\u0006\u0010^\u001a\u00020\u0004J\u000e\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020bJ\u0006\u0010c\u001a\u00020\u0012J\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020\u00042\b\u0010g\u001a\u0004\u0018\u00010hJ\u0006\u0010i\u001a\u00020MJ\u0016\u0010j\u001a\u00020D2\u0006\u0010k\u001a\u00020\u00042\u0006\u0010l\u001a\u00020\u001eJ\u0006\u0010m\u001a\u00020nJ\u0006\u0010o\u001a\u00020pJ\u0006\u0010q\u001a\u00020rJ\u0006\u0010s\u001a\u00020tJ\u0006\u0010u\u001a\u00020vJ\u0006\u0010w\u001a\u00020xJ\f\u0010y\u001a\b\u0012\u0004\u0012\u00020\u000e0WJ\f\u0010z\u001a\b\u0012\u0004\u0012\u00020{0WJ\f\u0010|\u001a\b\u0012\u0004\u0012\u00020\u001e0WJ\u0006\u0010}\u001a\u00020~J\u0006\u0010\u007f\u001a\u00020MJ\u0007\u0010\u0080\u0001\u001a\u00020MJ\u001a\u0010\u0081\u0001\u001a\u00020D2\u0007\u0010\u0082\u0001\u001a\u00020\u00042\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J!\u0010\u0081\u0001\u001a\u00020D2\u000e\u0010\u0085\u0001\u001a\t\u0012\u0004\u0012\u00020\u00040\u0086\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J&\u0010\u0087\u0001\u001a\u00020M2\u0007\u0010\u0088\u0001\u001a\u00020\u00042\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\n\b\u0002\u0010\u008b\u0001\u001a\u00030\u008c\u0001J\t\u0010\u008d\u0001\u001a\u00020DH\u0002J\u0007\u0010\u008e\u0001\u001a\u00020DJ\u0018\u0010\u008f\u0001\u001a\u00020M2\u0006\u0010k\u001a\u00020\u00042\u0007\u0010\u0090\u0001\u001a\u00020\u0004J\u0007\u0010\u0091\u0001\u001a\u00020DJ\u0018\u0010\u0092\u0001\u001a\u00020M2\u0006\u0010k\u001a\u00020\u00042\u0007\u0010\u0090\u0001\u001a\u00020\u0004J\u0012\u0010\u0093\u0001\u001a\u00030\u0094\u00012\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001J\u0007\u0010\u0097\u0001\u001a\u00020MJ\u0007\u0010\u0098\u0001\u001a\u00020MJ\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001c\u00105\u001a\u0004\u0018\u000106X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001c\u0010;\u001a\u0004\u0018\u00010<X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0010\u0010A\u001a\u0004\u0018\u00010BX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009b\u0001"}, d2={"Lcom/amity/socialcloud/sdk/core/CoreClient;", "", "()V", "TAG", "", "analyticsEngine", "Lcom/amity/socialcloud/sdk/core/engine/analytics/AnalyticsEngine;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "getAppEventBus$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "setAppEventBus$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;)V", "currentSessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "getCurrentSessionState", "()Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "isUnreadCountEnable", "", "markReadEngine", "Lcom/amity/socialcloud/sdk/core/MarkReadEngine;", "markerSyncEngine", "Lcom/amity/socialcloud/sdk/core/MarkerSyncEngine;", "messagePreviewEngine", "Lcom/amity/socialcloud/sdk/core/MessagePreviewEngine;", "messageReadReceiptSyncEngine", "Lcom/amity/socialcloud/sdk/core/MessageReadReceiptSyncEngine;", "messageSyncEngine", "Lcom/amity/socialcloud/sdk/core/MessageSyncEngine;", "millisTimeDiff", "", "getMillisTimeDiff$amity_sdk_release", "()I", "setMillisTimeDiff$amity_sdk_release", "(I)V", "mqttClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "objectResolverEngine", "Lcom/amity/socialcloud/sdk/core/ObjectResolverEngine;", "presenceSyncEngine", "Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;", "getPresenceSyncEngine$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;", "setPresenceSyncEngine$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;)V", "renewalManager", "Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "getSessionLifeCycleEventBus$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "setSessionLifeCycleEventBus$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;)V", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "getSessionStateEventBus$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "setSessionStateEventBus$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "sessionStateManager", "Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "getSessionStateManager$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "setSessionStateManager$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;)V", "socketClient", "Lcom/ekoapp/ekosdk/internal/api/EkoSocket;", "createAttachmentMessage", "", "message", "Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;", "emitter", "Lio/reactivex/rxjava3/core/CompletableEmitter;", "attachment", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessageAttachment;", "createTextMessage", "disconnect", "Lio/reactivex/rxjava3/core/Completable;", "enableUnreadCount", "getAmityCoreSdkVersion", "getAnalyticsEngine", "getConfiguration", "Lcom/amity/socialcloud/sdk/streamapi/AmityClientConfiguration;", "getContentCheck", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentCheck;", "getCurrentUser", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "getGlobalBanEvents", "Lcom/amity/socialcloud/sdk/model/core/session/AmityGlobalBanEvent;", "getServerTime", "Lorg/joda/time/DateTime;", "getServerTime$amity_sdk_release", "getUserId", "hasPermission", "Lcom/amity/socialcloud/sdk/api/core/permission/AmityPermissionValidator;", "permission", "Lcom/amity/socialcloud/sdk/model/core/permission/AmityPermission;", "isConsistentMode", "login", "Lcom/amity/socialcloud/sdk/api/core/session/AmitySessionEstablisher$Builder;", "userId", "sessionHandler", "Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "logout", "markRead", "subChannelId", "segment", "newFileRepository", "Lcom/amity/socialcloud/sdk/api/core/file/AmityFileRepository;", "newReactionRepository", "Lcom/amity/socialcloud/sdk/api/core/reaction/AmityReactionRepository;", "newUserPresenceRepository", "Lcom/amity/socialcloud/sdk/api/core/presence/AmityUserPresenceRepository;", "newUserRepository", "Lcom/amity/socialcloud/sdk/api/core/user/AmityUserRepository;", "notification", "Lcom/amity/socialcloud/sdk/api/core/user/notification/AmityUserNotification;", "notifications", "Lcom/amity/socialcloud/sdk/api/core/notification/AmityNotification;", "observeSessionState", "observeUserUnread", "Lcom/amity/socialcloud/sdk/model/core/unread/UserUnread;", "observeUserUnreadCount", "presence", "Lcom/amity/socialcloud/sdk/api/core/presence/AmityPresenceService;", "registerDeviceForPushNotification", "registerPushNotification", "resolve", "id", "referenceType", "Lcom/amity/socialcloud/sdk/core/ObjectResolverEngine$Companion$ReferenceType;", "ids", "", "setup", "apiKey", "endpoint", "Lcom/amity/socialcloud/sdk/api/core/endpoint/AmityEndpoint;", "dbEncryption", "Lcom/amity/socialcloud/sdk/api/core/encryption/AmityDBEncryption;", "setupSessionComponents", "startMarkerSyncing", "startReading", "channelId", "stopMarkerSyncing", "stopReading", "subscription", "Lcom/amity/socialcloud/sdk/api/core/events/AmityTopicSubscription;", "topic", "Lcom/amity/socialcloud/sdk/model/core/events/AmityTopic;", "unregisterDeviceForPushNotification", "unregisterPushNotification", "updateUser", "Lcom/amity/socialcloud/sdk/api/core/user/update/AmityUserUpdate$Builder;", "amity-sdk_release"})
public final class CoreClient {
    @NotNull
    public static final CoreClient INSTANCE = new CoreClient();
    @NotNull
    private static final String TAG = "AmityCoreClient";
    private static int millisTimeDiff;
    @Nullable
    private static AmityMqttClient mqttClient;
    @Nullable
    private static EkoSocket socketClient;
    @Nullable
    private static TokenRenewalSessionComponent renewalManager;
    @Nullable
    private static PresenceSyncEngine presenceSyncEngine;
    @Nullable
    private static AnalyticsEngine analyticsEngine;
    @Nullable
    private static SessionLifeCycleEventBus sessionLifeCycleEventBus;
    @Nullable
    private static AppEventBus appEventBus;
    @Nullable
    private static SessionStateEventBus sessionStateEventBus;
    @Nullable
    private static SessionStateManager sessionStateManager;
    @Nullable
    private static MarkerSyncEngine markerSyncEngine;
    @Nullable
    private static MarkReadEngine markReadEngine;
    @Nullable
    private static MessagePreviewEngine messagePreviewEngine;
    @Nullable
    private static MessageSyncEngine messageSyncEngine;
    @Nullable
    private static MessageReadReceiptSyncEngine messageReadReceiptSyncEngine;
    @Nullable
    private static ObjectResolverEngine objectResolverEngine;
    private static boolean isUnreadCountEnable;

    private CoreClient() {
    }

    public final int getMillisTimeDiff$amity_sdk_release() {
        return millisTimeDiff;
    }

    public final void setMillisTimeDiff$amity_sdk_release(int n) {
        millisTimeDiff = n;
    }

    @NotNull
    public final DateTime getServerTime$amity_sdk_release() {
        DateTime dateTime = DateTime.now().plusMillis(millisTimeDiff);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now().plusMillis(millisTimeDiff)");
        return dateTime;
    }

    @Nullable
    public final PresenceSyncEngine getPresenceSyncEngine$amity_sdk_release() {
        return presenceSyncEngine;
    }

    public final void setPresenceSyncEngine$amity_sdk_release(@Nullable PresenceSyncEngine presenceSyncEngine) {
        CoreClient.presenceSyncEngine = presenceSyncEngine;
    }

    @Nullable
    public final SessionLifeCycleEventBus getSessionLifeCycleEventBus$amity_sdk_release() {
        return sessionLifeCycleEventBus;
    }

    public final void setSessionLifeCycleEventBus$amity_sdk_release(@Nullable SessionLifeCycleEventBus sessionLifeCycleEventBus) {
        CoreClient.sessionLifeCycleEventBus = sessionLifeCycleEventBus;
    }

    @Nullable
    public final AppEventBus getAppEventBus$amity_sdk_release() {
        return appEventBus;
    }

    public final void setAppEventBus$amity_sdk_release(@Nullable AppEventBus appEventBus) {
        CoreClient.appEventBus = appEventBus;
    }

    @Nullable
    public final SessionStateEventBus getSessionStateEventBus$amity_sdk_release() {
        return sessionStateEventBus;
    }

    public final void setSessionStateEventBus$amity_sdk_release(@Nullable SessionStateEventBus sessionStateEventBus) {
        CoreClient.sessionStateEventBus = sessionStateEventBus;
    }

    @Nullable
    public final SessionStateManager getSessionStateManager$amity_sdk_release() {
        return sessionStateManager;
    }

    public final void setSessionStateManager$amity_sdk_release(@Nullable SessionStateManager sessionStateManager) {
        CoreClient.sessionStateManager = sessionStateManager;
    }

    @NotNull
    public final SessionState getCurrentSessionState() {
        SessionStateManager sessionStateManager = CoreClient.sessionStateManager;
        Intrinsics.checkNotNull((Object)sessionStateManager);
        return sessionStateManager.getSessionState();
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull AmityEndpoint endpoint, @NotNull AmityDBEncryption dbEncryption) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dbEncryption, (String)"dbEncryption");
        if (!EkoSdkInitProvider.Companion.isInitialized()) {
            Completable completable = Completable.never();
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
            return completable;
        }
        EkoPreconditions.checkValidId(apiKey, "apiKey");
        EkoDatabase.init(AppContext.get(), dbEncryption);
        UserDatabase.init(AppContext.get(), dbEncryption);
        CompletableSubject completableSubject = CompletableSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)completableSubject, (String)"create()");
        CompletableSubject result = completableSubject;
        EkoDatabase database = EkoDatabase.get();
        EkoHttpUrlDao httpUrlDao = database.httpUrlDao();
        EkoSocketUrlDao socketUrlDao = database.socketUrlDao();
        EkoMqttUrlDao mqttUrlDao = database.mqttUrlDao();
        String newHttpUrl = endpoint.getHttpEndpoint();
        String newSocketUrl = endpoint.getSocketEndpoint();
        String newMqttUrl = endpoint.getMqttEndpoint();
        EkoApiKeyDao apiKeyDao = EkoDatabase.get().apiKeyDao();
        Maybe.zip((MaybeSource)((MaybeSource)apiKeyDao.getCurrentApiKey()), (MaybeSource)((MaybeSource)httpUrlDao.getCurrentHttpUrl()), (MaybeSource)((MaybeSource)socketUrlDao.getCurrentSocketUrl()), (MaybeSource)((MaybeSource)mqttUrlDao.getCurrentMqttUrl()), (Function4)setup.1.INSTANCE).subscribeOn(Schedulers.io()).doOnSuccess(new Consumer(newHttpUrl, newSocketUrl, newMqttUrl, apiKey, httpUrlDao, socketUrlDao, mqttUrlDao, apiKeyDao){
            final /* synthetic */ String $newHttpUrl;
            final /* synthetic */ String $newSocketUrl;
            final /* synthetic */ String $newMqttUrl;
            final /* synthetic */ String $apiKey;
            final /* synthetic */ EkoHttpUrlDao $httpUrlDao;
            final /* synthetic */ EkoSocketUrlDao $socketUrlDao;
            final /* synthetic */ EkoMqttUrlDao $mqttUrlDao;
            final /* synthetic */ EkoApiKeyDao $apiKeyDao;
            {
                this.$newHttpUrl = $newHttpUrl;
                this.$newSocketUrl = $newSocketUrl;
                this.$newMqttUrl = $newMqttUrl;
                this.$apiKey = $apiKey;
                this.$httpUrlDao = $httpUrlDao;
                this.$socketUrlDao = $socketUrlDao;
                this.$mqttUrlDao = $mqttUrlDao;
                this.$apiKeyDao = $apiKeyDao;
            }

            public final void accept(@NotNull Pair<? extends EkoApiKey, ? extends AmityEndpoint> setupPair) {
                Intrinsics.checkNotNullParameter(setupPair, (String)"setupPair");
                String string = ((EkoApiKey)setupPair.getFirst()).getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"setupPair.first.apiKey");
                String storedApiKey = string;
                String storedHttpUrl = ((AmityEndpoint)setupPair.getSecond()).getHttpEndpoint();
                String storedSocketUrl = ((AmityEndpoint)setupPair.getSecond()).getSocketEndpoint();
                String storedMqttUrl = ((AmityEndpoint)setupPair.getSecond()).getMqttEndpoint();
                if (!(Objects.equal((Object)storedHttpUrl, (Object)this.$newHttpUrl) && Objects.equal((Object)storedSocketUrl, (Object)this.$newSocketUrl) && Objects.equal((Object)storedMqttUrl, (Object)this.$newMqttUrl) && Objects.equal((Object)storedApiKey, (Object)this.$apiKey))) {
                    Object[] objectArray = new Object[]{this.$apiKey, this.$newHttpUrl, this.$newSocketUrl, this.$newMqttUrl};
                    AmityLog.INSTANCE.tag("AmityCoreClient").e("Setup value changed. new api key: %s new http url: %s new socket url: %s new mqtt url: %s", objectArray);
                    AmityLog.INSTANCE.tag("AmityCoreClient").e("deleting user database", new Object[0]);
                    CoreClient.INSTANCE.logout();
                    this.$httpUrlDao.insert(EkoHttpUrl.create(this.$newHttpUrl));
                    this.$socketUrlDao.insert(EkoSocketUrl.create(this.$newSocketUrl));
                    this.$mqttUrlDao.insert(EkoMqttUrl.create(this.$newMqttUrl));
                    this.$apiKeyDao.insert(EkoApiKey.create(this.$apiKey));
                }
                AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
            }
        }).doOnComplete(() -> CoreClient.setup$lambda$0(httpUrlDao, newHttpUrl, socketUrlDao, newSocketUrl, mqttUrlDao, newMqttUrl, apiKeyDao, apiKey)).flatMapCompletable((Function)setup.4.INSTANCE).subscribe((CompletableObserver)result);
        this.setupSessionComponents();
        Completable completable = result.hide();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"result.hide()");
        return completable;
    }

    public static /* synthetic */ Completable setup$default(CoreClient coreClient, String string, AmityEndpoint amityEndpoint, AmityDBEncryption amityDBEncryption, int n, Object object) {
        if ((n & 4) != 0) {
            amityDBEncryption = AmityDBEncryption.NONE.INSTANCE;
        }
        return coreClient.setup(string, amityEndpoint, amityDBEncryption);
    }

    @NotNull
    public final Completable registerDeviceForPushNotification() {
        return this.registerPushNotification();
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification() {
        return this.unregisterPushNotification();
    }

    @NotNull
    public final Completable registerPushNotification() {
        return new RegisterDeviceForNotificationUseCase().execute();
    }

    @NotNull
    public final Completable unregisterPushNotification() {
        return new UnregisterAllUsersForNotificationUseCase().execute();
    }

    @NotNull
    public final Completable disconnect() {
        Completable completable;
        if (mqttClient == null || socketClient == null) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n            Completable.complete()\n        }");
        } else {
            EkoSocket ekoSocket = socketClient;
            if (ekoSocket != null) {
                ekoSocket.disconnect();
            }
            AmityMqttClient amityMqttClient = mqttClient;
            Intrinsics.checkNotNull((Object)amityMqttClient);
            completable = amityMqttClient.disconnect();
        }
        return completable;
    }

    @NotNull
    public final AmitySessionEstablisher.Builder login(@NotNull String userId, @Nullable SessionHandler sessionHandler) {
        boolean isLegacyVersion;
        block2: {
            SessionState sessionState;
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            isLegacyVersion = sessionHandler == null;
            SessionStateManager sessionStateManager = CoreClient.sessionStateManager;
            SessionState sessionState2 = sessionState = sessionStateManager != null ? sessionStateManager.getSessionState() : null;
            if (sessionState instanceof SessionState.Establishing) {
                throw SessionError.INSTANCE.fromState(sessionState);
            }
            SessionHandler sessionHandler2 = sessionHandler;
            if (sessionHandler2 == null) break block2;
            SessionHandler it = sessionHandler2;
            boolean bl = false;
            TokenRenewalSessionComponent tokenRenewalSessionComponent = renewalManager;
            if (tokenRenewalSessionComponent != null) {
                tokenRenewalSessionComponent.setSessionHandler(it);
            }
        }
        return new AmitySessionEstablisher.Builder(appEventBus, sessionLifeCycleEventBus, userId, isLegacyVersion);
    }

    @NotNull
    public final Completable logout() {
        block0: {
            AppEventBus appEventBus = CoreClient.appEventBus;
            if (appEventBus == null) break block0;
            appEventBus.publish(AppEvent.ManualLogout.INSTANCE);
        }
        return new LogoutUseCase().execute();
    }

    @NotNull
    public final String getUserId() {
        return new ActiveUserIdGetUseCase().execute();
    }

    @NotNull
    public final AmityUserUpdate.Builder updateUser() {
        return new AmityUserUpdate.Builder(this.getUserId());
    }

    @NotNull
    public final AmityPermissionValidator hasPermission(@NotNull AmityPermission permission) {
        Intrinsics.checkNotNullParameter((Object)((Object)permission), (String)"permission");
        return new AmityPermissionValidator(permission);
    }

    @NotNull
    public final Flowable<AmityUser> getCurrentUser() {
        return this.newUserRepository().getCurrentUser();
    }

    @NotNull
    public final AmityUserRepository newUserRepository() {
        return new AmityUserRepository();
    }

    @NotNull
    public final AmityFileRepository newFileRepository() {
        return new AmityFileRepository();
    }

    @NotNull
    public final AmityReactionRepository newReactionRepository() {
        return new AmityReactionRepository();
    }

    @NotNull
    public final String getAmityCoreSdkVersion() {
        return "6.30.0";
    }

    @NotNull
    public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
        return EkoSocket.Companion.getGlobalBanEvents();
    }

    @NotNull
    public final AmityUserNotification notification() {
        return new AmityUserNotification();
    }

    @NotNull
    public final AmityNotification notifications() {
        return new AmityNotification();
    }

    @NotNull
    public final AmityClientConfiguration getConfiguration() {
        return new AmityClientConfiguration((StreamFunctionInterface)new StreamFunction());
    }

    @NotNull
    public final AmityTopicSubscription subscription(@NotNull AmityTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return new AmityTopicSubscription(topic);
    }

    @NotNull
    public final Single<AmityContentCheck> getContentCheck() {
        return new GetContentCheckUseCase().execute();
    }

    @NotNull
    public final Flowable<SessionState> observeSessionState() {
        SessionStateEventBus sessionStateEventBus = CoreClient.sessionStateEventBus;
        Intrinsics.checkNotNull((Object)sessionStateEventBus);
        return sessionStateEventBus.observe();
    }

    @NotNull
    public final Completable startReading(@NotNull String subChannelId, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        MarkReadEngine markReadEngine = CoreClient.markReadEngine;
        if (markReadEngine == null || (markReadEngine = markReadEngine.startReading(subChannelId, channelId)) == null) {
            Completable completable = Completable.never();
            markReadEngine = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
        }
        return markReadEngine;
    }

    @NotNull
    public final Completable stopReading(@NotNull String subChannelId, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        MarkReadEngine markReadEngine = CoreClient.markReadEngine;
        if (markReadEngine == null || (markReadEngine = markReadEngine.stopReading(subChannelId, channelId)) == null) {
            Completable completable = Completable.never();
            markReadEngine = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
        }
        return markReadEngine;
    }

    public final void startMarkerSyncing() {
        block0: {
            MarkerSyncEngine markerSyncEngine = CoreClient.markerSyncEngine;
            if (markerSyncEngine == null) break block0;
            markerSyncEngine.startMarkerSync();
        }
    }

    public final void stopMarkerSyncing() {
        block0: {
            MarkerSyncEngine markerSyncEngine = CoreClient.markerSyncEngine;
            if (markerSyncEngine == null) break block0;
            markerSyncEngine.stopMarkerSync();
        }
    }

    @NotNull
    public final Flowable<Integer> observeUserUnreadCount() {
        Flowable flowable = new ObserveUserMarker().execute().map((Function)observeUserUnreadCount.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ObserveUserMarker().exec\u2026().map { it.unreadCount }");
        return flowable;
    }

    @NotNull
    public final Flowable<UserUnread> observeUserUnread() {
        UserUnreadModelMapper userUnreadModelMapper = new UserUnreadModelMapper();
        Flowable flowable = new ObserveUserMarker().execute().map(new Function(userUnreadModelMapper){
            final /* synthetic */ UserUnreadModelMapper $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final UserUnread apply(@NotNull UserMarkerEntity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$tmp0.map(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ObserveUserMarker().exec\u2026UnreadModelMapper()::map)");
        return flowable;
    }

    @NotNull
    public final AmityPresenceService presence() {
        return new AmityPresenceService(presenceSyncEngine);
    }

    @NotNull
    public final AmityUserPresenceRepository newUserPresenceRepository() {
        return new AmityUserPresenceRepository();
    }

    @Nullable
    public final AnalyticsEngine getAnalyticsEngine() {
        return analyticsEngine;
    }

    public final void createTextMessage(@NotNull EkoMessageEntity message, @NotNull CompletableEmitter emitter) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
            MessageSyncEngine messageSyncEngine = CoreClient.messageSyncEngine;
            if (messageSyncEngine == null) break block0;
            messageSyncEngine.addTextMessageJob(message, emitter);
        }
    }

    public final void createAttachmentMessage(@NotNull EkoMessageEntity message, @NotNull CompletableEmitter emitter, @NotNull AmityMessageAttachment attachment) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            MessageSyncEngine messageSyncEngine = CoreClient.messageSyncEngine;
            if (messageSyncEngine == null) break block0;
            messageSyncEngine.addAttachmentMessageJob(message, emitter, attachment);
        }
    }

    public final boolean isConsistentMode() {
        MarkerSyncEngine markerSyncEngine = CoreClient.markerSyncEngine;
        return markerSyncEngine != null ? markerSyncEngine.isConsistentMode() : true;
    }

    public final boolean isUnreadCountEnable() {
        return isUnreadCountEnable;
    }

    public final void enableUnreadCount() {
        isUnreadCountEnable = true;
    }

    public final void markRead(@NotNull String subChannelId, int segment) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
            MessageReadReceiptSyncEngine messageReadReceiptSyncEngine = CoreClient.messageReadReceiptSyncEngine;
            if (messageReadReceiptSyncEngine == null) break block0;
            messageReadReceiptSyncEngine.markRead(subChannelId, segment);
        }
    }

    public final void resolve(@NotNull String id, @NotNull ObjectResolverEngine.Companion.ReferenceType referenceType) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
            ObjectResolverEngine objectResolverEngine = CoreClient.objectResolverEngine;
            if (objectResolverEngine == null) break block0;
            objectResolverEngine.resolve(id, referenceType);
        }
    }

    public final void resolve(@NotNull List<String> ids, @NotNull ObjectResolverEngine.Companion.ReferenceType referenceType) {
        block0: {
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
            ObjectResolverEngine objectResolverEngine = CoreClient.objectResolverEngine;
            if (objectResolverEngine == null) break block0;
            objectResolverEngine.resolve(ids, referenceType);
        }
    }

    private final void setupSessionComponents() {
        if (sessionLifeCycleEventBus == null) {
            sessionLifeCycleEventBus = new SessionLifeCycleEventBus();
        }
        if (appEventBus == null) {
            appEventBus = new AppEventBus();
        }
        if (sessionStateEventBus == null) {
            sessionStateEventBus = new SessionStateEventBus();
        }
        if (sessionStateManager == null) {
            AppEventBus appEventBus = CoreClient.appEventBus;
            Intrinsics.checkNotNull((Object)appEventBus);
            AppEventBus appEventBus2 = appEventBus;
            SessionStateEventBus sessionStateEventBus = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus);
            SessionStateEventBus sessionStateEventBus2 = sessionStateEventBus;
            SessionLifeCycleEventBus sessionLifeCycleEventBus = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus);
            SessionLifeCycleEventBus sessionLifeCycleEventBus2 = sessionLifeCycleEventBus;
            sessionStateManager = new SessionStateManager(appEventBus2, sessionLifeCycleEventBus2, sessionStateEventBus2);
        }
        if (mqttClient == null || socketClient == null || renewalManager == null) {
            SessionLifeCycleEventBus sessionLifeCycleEventBus = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus);
            SessionStateEventBus sessionStateEventBus = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus);
            mqttClient = new AmityMqttClient(sessionLifeCycleEventBus, sessionStateEventBus);
            SessionLifeCycleEventBus sessionLifeCycleEventBus3 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus3);
            SessionStateEventBus sessionStateEventBus3 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus3);
            socketClient = new EkoSocket(sessionLifeCycleEventBus3, sessionStateEventBus3);
            AppEventBus appEventBus = CoreClient.appEventBus;
            Intrinsics.checkNotNull((Object)appEventBus);
            SessionLifeCycleEventBus sessionLifeCycleEventBus4 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus4);
            SessionStateEventBus sessionStateEventBus4 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus4);
            renewalManager = new TokenRenewalSessionComponent(appEventBus, sessionLifeCycleEventBus4, sessionStateEventBus4);
            SessionLifeCycleEventBus sessionLifeCycleEventBus5 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus5);
            SessionStateEventBus sessionStateEventBus5 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus5);
            presenceSyncEngine = new PresenceSyncEngine(sessionLifeCycleEventBus5, sessionStateEventBus5);
            SessionLifeCycleEventBus sessionLifeCycleEventBus6 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus6);
            SessionStateEventBus sessionStateEventBus6 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus6);
            analyticsEngine = new AnalyticsEngine(sessionLifeCycleEventBus6, sessionStateEventBus6);
            SessionLifeCycleEventBus sessionLifeCycleEventBus7 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus7);
            SessionStateEventBus sessionStateEventBus7 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus7);
            new AmityHttpClient(sessionLifeCycleEventBus7, sessionStateEventBus7);
            SessionLifeCycleEventBus sessionLifeCycleEventBus8 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus8);
            SessionStateEventBus sessionStateEventBus8 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus8);
            new DatabaseSessionComponent(sessionLifeCycleEventBus8, sessionStateEventBus8);
            SessionLifeCycleEventBus sessionLifeCycleEventBus9 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus9);
            SessionStateEventBus sessionStateEventBus9 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus9);
            new UserSettingSessionComponent(sessionLifeCycleEventBus9, sessionStateEventBus9);
            AppEventBus appEventBus3 = CoreClient.appEventBus;
            Intrinsics.checkNotNull((Object)appEventBus3);
            SessionLifeCycleEventBus sessionLifeCycleEventBus10 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus10);
            SessionStateEventBus sessionStateEventBus10 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus10);
            new TokenWatcherSessionComponent(appEventBus3, sessionLifeCycleEventBus10, sessionStateEventBus10);
            SessionLifeCycleEventBus sessionLifeCycleEventBus11 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus11);
            SessionStateEventBus sessionStateEventBus11 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus11);
            markerSyncEngine = new MarkerSyncEngine(sessionLifeCycleEventBus11, sessionStateEventBus11);
            SessionLifeCycleEventBus sessionLifeCycleEventBus12 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus12);
            SessionStateEventBus sessionStateEventBus12 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus12);
            markReadEngine = new MarkReadEngine(sessionLifeCycleEventBus12, sessionStateEventBus12);
            SessionLifeCycleEventBus sessionLifeCycleEventBus13 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus13);
            SessionStateEventBus sessionStateEventBus13 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus13);
            messagePreviewEngine = new MessagePreviewEngine(sessionLifeCycleEventBus13, sessionStateEventBus13);
            SessionLifeCycleEventBus sessionLifeCycleEventBus14 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus14);
            SessionStateEventBus sessionStateEventBus14 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus14);
            messageSyncEngine = new MessageSyncEngine(sessionLifeCycleEventBus14, sessionStateEventBus14);
            SessionLifeCycleEventBus sessionLifeCycleEventBus15 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus15);
            SessionStateEventBus sessionStateEventBus15 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus15);
            messageReadReceiptSyncEngine = new MessageReadReceiptSyncEngine(sessionLifeCycleEventBus15, sessionStateEventBus15);
            SessionLifeCycleEventBus sessionLifeCycleEventBus16 = CoreClient.sessionLifeCycleEventBus;
            Intrinsics.checkNotNull((Object)sessionLifeCycleEventBus16);
            SessionStateEventBus sessionStateEventBus16 = CoreClient.sessionStateEventBus;
            Intrinsics.checkNotNull((Object)sessionStateEventBus16);
            objectResolverEngine = new ObjectResolverEngine(sessionLifeCycleEventBus16, sessionStateEventBus16);
        }
    }

    private static final void setup$lambda$0(EkoHttpUrlDao $httpUrlDao, String $newHttpUrl, EkoSocketUrlDao $socketUrlDao, String $newSocketUrl, EkoMqttUrlDao $mqttUrlDao, String $newMqttUrl, EkoApiKeyDao $apiKeyDao, String $apiKey) {
        Intrinsics.checkNotNullParameter((Object)$newHttpUrl, (String)"$newHttpUrl");
        Intrinsics.checkNotNullParameter((Object)$newSocketUrl, (String)"$newSocketUrl");
        Intrinsics.checkNotNullParameter((Object)$newMqttUrl, (String)"$newMqttUrl");
        Intrinsics.checkNotNullParameter((Object)$apiKey, (String)"$apiKey");
        $httpUrlDao.insert(EkoHttpUrl.create($newHttpUrl));
        $socketUrlDao.insert(EkoSocketUrl.create($newSocketUrl));
        $mqttUrlDao.insert(EkoMqttUrl.create($newMqttUrl));
        $apiKeyDao.insert(EkoApiKey.create($apiKey));
        AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
    }

    static {
        isUnreadCountEnable = true;
    }
}

