/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.post;

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase;
import com.amity.socialcloud.sdk.core.domain.file.FileGetUseCase;
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase;
import com.amity.socialcloud.sdk.core.domain.reaction.MyReactionsGetUseCase;
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase;
import com.amity.socialcloud.sdk.helper.core.mention.AmityMentionee;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.amity.socialcloud.sdk.model.social.post.AmityPost;
import com.amity.socialcloud.sdk.social.domain.comment.LatestCommentsGetUseCase;
import com.amity.socialcloud.sdk.social.domain.community.CommunityGetUseCase;
import com.amity.socialcloud.sdk.social.domain.community.member.CommunityMemberGetUseCase;
import com.amity.socialcloud.sdk.social.domain.post.PostsGetUseCase;
import com.amity.socialcloud.sdk.social.domain.post.flag.IsPostFlaggedByMeUseCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/post/PostComposerUseCase;", "Lcom/amity/socialcloud/sdk/core/domain/ComposerUseCase;", "()V", "addChildren", "", "post", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost;", "addData", "addLatestComments", "addMentionees", "addMyFlag", "addMyReactions", "addPostedUser", "addSharedUser", "addTarget", "execute", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nPostComposerUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostComposerUseCase.kt\ncom/amity/socialcloud/sdk/social/domain/post/PostComposerUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1549#2:106\n1620#2,3:107\n*S KotlinDebug\n*F\n+ 1 PostComposerUseCase.kt\ncom/amity/socialcloud/sdk/social/domain/post/PostComposerUseCase\n*L\n79#1:106\n79#1:107,3\n*E\n"})
public final class PostComposerUseCase
extends ComposerUseCase {
    @NotNull
    public final AmityPost execute(@NotNull AmityPost post) {
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        this.addChildren(post);
        this.addData(post);
        this.addMyReactions(post);
        this.addMyFlag(post);
        this.addPostedUser(post);
        this.addSharedUser(post);
        this.addTarget(post);
        this.addLatestComments(post);
        this.addMentionees(post);
        return post;
    }

    private final void addChildren(AmityPost post) {
        post.setChildren$amity_sdk_release(new PostsGetUseCase().execute(post.getChildrenPostIds$amity_sdk_release()));
    }

    private final void addData(AmityPost post) {
        AmityPost.Data data = post.getData$amity_sdk_release();
        if (data instanceof AmityPost.Data.IMAGE) {
            ((AmityPost.Data.IMAGE)post.getData$amity_sdk_release()).setImage$amity_sdk_release(new ImageGetUseCase().execute(((AmityPost.Data.IMAGE)post.getData$amity_sdk_release()).getFileId$amity_sdk_release()));
        } else if (data instanceof AmityPost.Data.FILE) {
            ((AmityPost.Data.FILE)post.getData$amity_sdk_release()).setFile$amity_sdk_release(new FileGetUseCase().execute(((AmityPost.Data.FILE)post.getData$amity_sdk_release()).getFileId$amity_sdk_release()));
        } else if (data instanceof AmityPost.Data.VIDEO) {
            ((AmityPost.Data.VIDEO)post.getData$amity_sdk_release()).setThumbnail$amity_sdk_release(new ImageGetUseCase().execute(((AmityPost.Data.VIDEO)post.getData$amity_sdk_release()).getThumbnailFileId$amity_sdk_release()));
        }
    }

    private final void addMyReactions(AmityPost post) {
        post.setMyReactions$amity_sdk_release(new MyReactionsGetUseCase().execute(AmityReactionReferenceType.POST, post.getPostId()));
    }

    private final void addMyFlag(AmityPost post) {
        post.setFlaggedByMe$amity_sdk_release(new IsPostFlaggedByMeUseCase().execute(post.getPostId()));
    }

    private final void addPostedUser(AmityPost post) {
        post.setPostedUser$amity_sdk_release(new UserGetUseCase().execute(post.getCreatorId()));
    }

    private final void addSharedUser(AmityPost post) {
        block0: {
            String string = post.getSharedUserId$amity_sdk_release();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            post.setSharedUser$amity_sdk_release(new UserGetUseCase().execute(it));
        }
    }

    private final void addLatestComments(AmityPost post) {
        post.setLatestComments$amity_sdk_release(new LatestCommentsGetUseCase().execute("post", post.getPostId()));
    }

    /*
     * WARNING - void declaration
     */
    private final void addMentionees(AmityPost post) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = post.getMentionees();
        AmityPost amityPost = post;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AmityMentionee amityMentionee = (AmityMentionee)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof AmityMentionee.USER) {
                ((AmityMentionee.USER)it).setUser$amity_sdk_release(new UserGetUseCase().execute(((AmityMentionee.USER)it).getUserId()));
            }
            collection.add(it);
        }
        amityPost.setMentionees$amity_sdk_release((List)destination$iv$iv);
    }

    private final void addTarget(AmityPost post) {
        AmityPost.Target target = post.getTarget$amity_sdk_release();
        if (target instanceof AmityPost.Target.COMMUNITY) {
            ((AmityPost.Target.COMMUNITY)post.getTarget$amity_sdk_release()).setTargetCommunity$amity_sdk_release(new CommunityGetUseCase().execute(((AmityPost.Target.COMMUNITY)post.getTarget$amity_sdk_release()).getTargetCommunityId$amity_sdk_release()));
            ((AmityPost.Target.COMMUNITY)post.getTarget$amity_sdk_release()).setPostedCommunityMember$amity_sdk_release(new CommunityMemberGetUseCase().execute(((AmityPost.Target.COMMUNITY)post.getTarget$amity_sdk_release()).getTargetCommunityId$amity_sdk_release(), post.getPostedUserId$amity_sdk_release()));
        } else if (target instanceof AmityPost.Target.USER) {
            ((AmityPost.Target.USER)post.getTarget$amity_sdk_release()).setTargetUser$amity_sdk_release(new UserGetUseCase().execute(((AmityPost.Target.USER)post.getTarget$amity_sdk_release()).getTargetUserId$amity_sdk_release()));
        }
    }
}

