/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.AmityPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelTagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoTagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoChannelTag;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000fH'J\b\u0010\u0014\u001a\u00020\u000fH\u0017J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H'J\u001c\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00120\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H'J\u001a\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u001a2\u0006\u0010\u001b\u001a\u00020\u0017J$\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u001a2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H'J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H'J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0016J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H'J\u0010\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020\u0017J\u0014\u0010'\u001a\u0004\u0018\u00010\u00022\b\u0010&\u001a\u0004\u0018\u00010\u0017H'J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H'J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010\u001b\u001a\u00020\u0017H'Js\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170-2\u0006\u0010\u001b\u001a\u00020\u00172\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00170-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00170-2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00170-2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u000207\u00a2\u0006\u0002\u00108J\u008d\u0001\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170-2\u0006\u0010:\u001a\u0002022\u0006\u0010\u001b\u001a\u00020\u00172\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00170-2\u0006\u0010;\u001a\u0002022\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00170-2\u0006\u0010<\u001a\u0002022\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00170-2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u000207H'\u00a2\u0006\u0002\u0010=J\u0012\u0010>\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0017H'J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0017J\u0016\u0010?\u001a\u00020\u000f2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0017J\u0010\u0010A\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H'J\u0010\u0010B\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0017J\u0018\u0010C\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010D\u001a\u000207H'J\u0018\u0010E\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00103\u001a\u000204H'J\u0018\u0010F\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010G\u001a\u000204H'J\u0018\u0010H\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010I\u001a\u00020\u0017H'R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/ekoapp/ekosdk/internal/data/dao/EkoChannelDao;", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoObjectDao;", "Lcom/ekoapp/ekosdk/internal/EkoChannelEntity;", "Lcom/ekoapp/ekosdk/internal/data/dao/AmityPagingDao;", "Lcom/ekoapp/ekosdk/EkoChannelWithMembershipAndExtra;", "()V", "channelExtraDao", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoChannelExtraDao;", "channelMembershipDao", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoChannelMembershipDao;", "channelTagDao", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoChannelTagDao;", "messageDao", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoMessageDao;", "beforeInsertOrUpdate", "", "channel", "cs", "", "deleteAll", "deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading", "deleteById", "channelId", "", "deleteByIdImpl", "getActiveIds", "Lio/reactivex/rxjava3/core/Flowable;", "userId", "getAllJoinedChannels", "getAllJoinedChannelsImpl", "membership", "getByIdNow", "id", "getByIdNowImpl", "getByIdsNow", "ids", "getByIdsNowImpl", "getByInternalIdNow", "internalId", "getByInternalIdNowImpl", "getChannel", "getChannelImpl", "getInactiveIds", "getLatestChannel", "types", "", "memberships", "includingTags", "excludingTags", "isDeleted", "", "hash", "", "nonce", "now", "Lorg/joda/time/DateTime;", "([Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Boolean;IILorg/joda/time/DateTime;)Lio/reactivex/rxjava3/core/Flowable;", "getLatestChannelImpl", "isFilterByMemberships", "isIncludingTags", "isExcludingTags", "([Ljava/lang/String;ZLjava/lang/String;[Ljava/lang/String;Z[Ljava/lang/String;Z[Ljava/lang/String;Ljava/lang/Boolean;IILorg/joda/time/DateTime;)Lio/reactivex/rxjava3/core/Flowable;", "getMessagePreviewId", "insert", "channels", "notifyChanges", "update", "updateLastActivity", "lastActivity", "updateMarkerHash", "updateMessageCount", "messageCount", "updateMessagePreview", "messagePreviewId", "amity-sdk_release"})
@Dao
public abstract class EkoChannelDao
extends EkoObjectDao<EkoChannelEntity>
implements AmityPagingDao<EkoChannelWithMembershipAndExtra> {
    @NotNull
    private final EkoChannelMembershipDao channelMembershipDao;
    @NotNull
    private final EkoMessageDao messageDao;
    @NotNull
    private final EkoChannelTagDao channelTagDao;
    @NotNull
    private final EkoChannelExtraDao channelExtraDao;

    public EkoChannelDao() {
        UserDatabase db = UserDatabase.get();
        EkoChannelMembershipDao ekoChannelMembershipDao = db.channelMembershipDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoChannelMembershipDao, (String)"db.channelMembershipDao()");
        this.channelMembershipDao = ekoChannelMembershipDao;
        EkoMessageDao ekoMessageDao = db.messageDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoMessageDao, (String)"db.messageDao()");
        this.messageDao = ekoMessageDao;
        EkoChannelTagDao ekoChannelTagDao = db.channelTagDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoChannelTagDao, (String)"db.channelTagDao()");
        this.channelTagDao = ekoChannelTagDao;
        EkoChannelExtraDao ekoChannelExtraDao = db.channelExtraDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoChannelExtraDao, (String)"db.channelExtraDao()");
        this.channelExtraDao = ekoChannelExtraDao;
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_membership where membership = :membership) and channel_membership.userId = :userId")
    @NotNull
    public abstract Flowable<List<EkoChannelWithMembershipAndExtra>> getAllJoinedChannelsImpl(@NotNull String var1, @NotNull String var2);

    @NotNull
    public final Flowable<List<EkoChannelWithMembershipAndExtra>> getAllJoinedChannels(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.getAllJoinedChannelsImpl(userId, AmityMembershipType.MEMBER.getApiKey());
    }

    @Query(value="SELECT * from channel where channel.channelType in (:types) and case when :isFilterByMemberships then channel.channelId in (SELECT channelId from channel_membership where membership in (:memberships) and userId = :userId) else channel.channelId is not null end and case when :isIncludingTags then channel.channelId in (SELECT channelId from channel_tag where tagName in (:includingTags)) else channel.channelId is not null end and case when :isExcludingTags then channel.channelId not in (SELECT channelId from channel_tag where tagName in (:excludingTags)) else channel.channelId is not null end and case when :isDeleted is not null then channel.isDeleted = :isDeleted else channel.channelId is not null end and channel.updatedAt > :now and channel.channelId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by channel.updatedAt  desc limit 1")
    @NotNull
    public abstract Flowable<EkoChannelEntity> getLatestChannelImpl(@NotNull String[] var1, boolean var2, @NotNull String var3, @NotNull String[] var4, boolean var5, @NotNull String[] var6, boolean var7, @NotNull String[] var8, @Nullable Boolean var9, int var10, int var11, @NotNull DateTime var12);

    @NotNull
    public final Flowable<EkoChannelEntity> getLatestChannel(@NotNull String[] types, @NotNull String userId, @NotNull String[] memberships, @NotNull String[] includingTags, @NotNull String[] excludingTags, @Nullable Boolean isDeleted, int hash, int nonce, @NotNull DateTime now) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)memberships, (String)"memberships");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        return this.getLatestChannelImpl(types, !(memberships.length == 0), userId, memberships, !(includingTags.length == 0), includingTags, !(excludingTags.length == 0), excludingTags, isDeleted, hash, nonce, now);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = :channelId LIMIT 1")
    @NotNull
    public abstract Flowable<EkoChannelWithMembershipAndExtra> getChannelImpl(@NotNull String var1);

    @NotNull
    public final Flowable<EkoChannelEntity> getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Flowable flowable = this.getChannelImpl(channelId).map(EkoChannelDao::getChannel$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"getChannelImpl(channelId\u2026ershipAndExtra -> input }");
        return flowable;
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = :channelId LIMIT 1")
    @NotNull
    public abstract EkoChannelWithMembershipAndExtra getByIdNowImpl(@NotNull String var1);

    @Override
    @NotNull
    public EkoChannelEntity getByIdNow(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getByIdNowImpl(id);
    }

    @Query(value="SELECT channel.* from channel where channel.internalChannelId = :internalId LIMIT 1")
    @Nullable
    public abstract EkoChannelEntity getByInternalIdNowImpl(@Nullable String var1);

    @Nullable
    public final EkoChannelEntity getByInternalIdNow(@NotNull String internalId) {
        Intrinsics.checkNotNullParameter((Object)internalId, (String)"internalId");
        return this.getByInternalIdNowImpl(internalId);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId  IN (:ids)")
    @NotNull
    public abstract List<EkoChannelWithMembershipAndExtra> getByIdsNowImpl(@NotNull List<String> var1);

    @Override
    @NotNull
    public List<EkoChannelEntity> getByIdsNow(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        ImmutableList immutableList = FluentIterable.from((Iterable)this.getByIdsNowImpl(ids)).transform(EkoChannelDao::getByIdsNow$lambda-1).toList();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"from(getByIdsNowImpl(ids\u2026\t\t\t\t\tinput\n\t\t\t\t}.toList()");
        return CollectionsKt.filterNotNull((Iterable)((Iterable)immutableList));
    }

    @Query(value="UPDATE channel set lastActivity = :lastActivity where channelId = :channelId")
    public abstract void updateLastActivity(@NotNull String var1, @NotNull DateTime var2);

    @Query(value="UPDATE channel set channelId = :channelId where channelId = :channelId")
    public abstract void notifyChanges(@NotNull String var1);

    @Query(value="UPDATE channel set messageCount = :messageCount where channelId = :channelId and messageCount < :messageCount")
    public abstract void updateMessageCount(@NotNull String var1, int var2);

    @Override
    @Query(value="DELETE from channel")
    public abstract void deleteAll();

    @Query(value="DELETE from channel where channelId = :channelId")
    public abstract void deleteByIdImpl(@NotNull String var1);

    @Transaction
    public void deleteById(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.deleteByIdImpl(channelId);
        this.messageDao.deleteAllFromChannel(channelId);
        this.channelMembershipDao.deleteAllFromChannel(channelId);
        this.channelExtraDao.deleteAllFromChannel(channelId);
    }

    @Query(value="SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where membership = 'member' and userId = :userId)")
    @NotNull
    public abstract Flowable<List<String>> getActiveIds(@NotNull String var1);

    @Query(value="SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where (membership = 'none' or membership = 'banned') and userId = :userId)")
    @NotNull
    public abstract List<String> getInactiveIds(@NotNull String var1);

    @Transaction
    public void deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading() {
        List<String> inactiveChannelIds = this.getInactiveIds(AmityCoreClient.INSTANCE.getUserId());
        for (String inactiveChannelId : inactiveChannelIds) {
            this.deleteById(inactiveChannelId);
        }
        this.channelExtraDao.updateAllReadStatuses(EkoChannelReadStatus.NOT_READING);
    }

    private final void beforeInsertOrUpdate(EkoChannelEntity channel) {
        EkoChannelEntity c = this.getByIdNow(channel.getChannelId());
        if (c != null) {
            channel.setMessageCount(Math.max(c.getMessageCount(), channel.getMessageCount()));
        }
    }

    private final void beforeInsertOrUpdate(List<? extends EkoChannelEntity> cs) {
        for (EkoChannelEntity ekoChannelEntity : cs) {
            this.beforeInsertOrUpdate(ekoChannelEntity);
        }
    }

    @Override
    @Transaction
    public void insert(@NotNull EkoChannelEntity channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.beforeInsertOrUpdate(channel);
        super.insert((EkoObject)channel);
        EkoTagDao.Companion.update(channel, (EkoTagDao)this.channelTagDao, EkoChannelTag.Companion.getFactory());
        this.channelExtraDao.insertOrUpdate(channel.getChannelId());
    }

    @Override
    @Transaction
    public void insert(@NotNull List<? extends EkoChannelEntity> channels) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        this.beforeInsertOrUpdate(channels);
        super.insert(channels);
        EkoTagDao.Companion.update(channels, (EkoTagDao)this.channelTagDao, EkoChannelTag.Companion.getFactory());
        ImmutableList immutableList = FluentIterable.from((Iterable)channels).transform(EkoChannelDao::insert$lambda-2).toList();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"from(channels)\n\t\t\t\t.tran\u2026nel?.channelId }.toList()");
        this.channelExtraDao.insertOrUpdate(CollectionsKt.filterNotNull((Iterable)((Iterable)immutableList)));
    }

    @Override
    @Transaction
    public void update(@NotNull EkoChannelEntity channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.beforeInsertOrUpdate(channel);
        super.update((EkoObject)channel);
        EkoTagDao.Companion.update(channel, (EkoTagDao)this.channelTagDao, EkoChannelTag.Companion.getFactory());
        this.channelExtraDao.insertOrUpdate(channel.getChannelId());
    }

    @Query(value="UPDATE channel set channelMarkerHash = :hash where channelId = :channelId")
    public abstract void updateMarkerHash(@NotNull String var1, int var2);

    @Query(value="UPDATE channel set messagePreviewId = :messagePreviewId where channelId = :channelId")
    public abstract void updateMessagePreview(@NotNull String var1, @NotNull String var2);

    @Query(value="SELECT messagePreviewId FROM  channel WHERE channelId = :channelId LIMIT 1")
    @Nullable
    public abstract String getMessagePreviewId(@NotNull String var1);

    private static final EkoChannelEntity getChannel$lambda-0(EkoChannelWithMembershipAndExtra input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input;
    }

    private static final EkoChannelWithMembershipAndExtra getByIdsNow$lambda-1(EkoChannelWithMembershipAndExtra input) {
        return input;
    }

    private static final String insert$lambda-2(EkoChannelEntity channel) {
        EkoChannelEntity ekoChannelEntity = channel;
        return ekoChannelEntity != null ? ekoChannelEntity.getChannelId() : null;
    }
}

