/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.engine.analytics.capturer;

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository;
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\b\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/amity/socialcloud/sdk/core/engine/analytics/capturer/AnalyticsEventCapturer;", "", "contentType", "", "activityType", "syncPriority", "Lcom/amity/socialcloud/sdk/core/engine/analytics/AnalyticsEventSyncPriority;", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/core/engine/analytics/AnalyticsEventSyncPriority;)V", "recentCaptured", "Ljava/util/HashMap;", "Lorg/joda/time/DateTime;", "Lkotlin/collections/HashMap;", "captureEvent", "", "contentId", "amity-sdk_release"})
public abstract class AnalyticsEventCapturer {
    @NotNull
    private final String contentType;
    @NotNull
    private final String activityType;
    @NotNull
    private final AnalyticsEventSyncPriority syncPriority;
    @NotNull
    private final HashMap<String, DateTime> recentCaptured;

    public AnalyticsEventCapturer(@NotNull String contentType, @NotNull String activityType, @NotNull AnalyticsEventSyncPriority syncPriority) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)activityType, (String)"activityType");
        Intrinsics.checkNotNullParameter((Object)((Object)syncPriority), (String)"syncPriority");
        this.contentType = contentType;
        this.activityType = activityType;
        this.syncPriority = syncPriority;
        this.recentCaptured = new HashMap();
    }

    public final void captureEvent(@NotNull String contentId) {
        Intrinsics.checkNotNullParameter((Object)contentId, (String)"contentId");
        DateTime dateTime = this.recentCaptured.get(contentId);
        boolean bl = dateTime != null && (dateTime = dateTime.plusSeconds(5)) != null ? dateTime.isAfterNow() : false;
        if (bl) {
            return;
        }
        new AnalyticsRepository().saveAnalyticEvent(contentId, this.contentType, this.activityType, this.syncPriority).subscribeOn(Schedulers.io()).doOnComplete(() -> AnalyticsEventCapturer.captureEvent$lambda-0(this, contentId)).doOnError(AnalyticsEventCapturer::captureEvent$lambda-1).subscribe();
    }

    private static final void captureEvent$lambda-0(AnalyticsEventCapturer this$0, String $contentId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$contentId, (String)"$contentId");
        ((Map)this$0.recentCaptured).put($contentId, DateTime.now());
    }

    private static final void captureEvent$lambda-1(Throwable it) {
    }
}

