/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.story.create;

import android.net.Uri;
import com.amity.socialcloud.sdk.core.data.file.FileRepository;
import com.amity.socialcloud.sdk.model.core.content.AmityContentFeedType;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityVideo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryItem;
import com.amity.socialcloud.sdk.social.data.story.StoryRepository;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002JB\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J@\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/story/create/CreateVideoStoryUseCase;", "", "()V", "createLocalStory", "Lio/reactivex/rxjava3/core/Completable;", "uniqueId", "", "targetType", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory$TargetType;", "targetId", "fileUri", "Landroid/net/Uri;", "storyItems", "", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryItem;", "metadata", "Lcom/google/gson/JsonObject;", "createRemoteStory", "fileId", "execute", "publishError", "referenceId", "exception", "Lcom/amity/socialcloud/sdk/model/core/error/AmityException;", "uploadFile", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "Lcom/amity/socialcloud/sdk/model/core/file/AmityVideo;", "amity-sdk_release"})
public final class CreateVideoStoryUseCase {
    @NotNull
    public final Completable execute(@NotNull String uniqueId, @NotNull AmityStory.TargetType targetType, @NotNull String targetId, @NotNull Uri fileUri, @NotNull List<? extends AmityStoryItem> storyItems, @Nullable JsonObject metadata) {
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Intrinsics.checkNotNullParameter(storyItems, (String)"storyItems");
        Completable completable = this.createLocalStory(uniqueId, targetType, targetId, fileUri, storyItems, metadata).andThen((CompletableSource)this.uploadFile(uniqueId, fileUri).flatMapCompletable(arg_0 -> CreateVideoStoryUseCase.execute$lambda-1(this, uniqueId, targetType, targetId, storyItems, metadata, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"createLocalStory(\n      \u2026              }\n        )");
        return completable;
    }

    public static /* synthetic */ Completable execute$default(CreateVideoStoryUseCase createVideoStoryUseCase, String string, AmityStory.TargetType targetType, String string2, Uri uri, List list, JsonObject jsonObject, int n, Object object) {
        if ((n & 1) != 0) {
            string = "LOCAL_" + UUID.randomUUID();
        }
        return createVideoStoryUseCase.execute(string, targetType, string2, uri, list, jsonObject);
    }

    private final Completable publishError(String referenceId, AmityException exception) {
        Completable completable = new StoryRepository().updateStorySyncState(referenceId, AmityStory.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)exception));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"StoryRepository().update\u2026letable.error(exception))");
        return completable;
    }

    private final Completable createLocalStory(String uniqueId, AmityStory.TargetType targetType, String targetId, Uri fileUri, List<? extends AmityStoryItem> storyItems, JsonObject metadata) {
        FileRepository fileRepository = new FileRepository();
        String string = AmityStory.DataType.VIDEO.getApiKey();
        String string2 = fileUri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileUri.toString()");
        Completable completable = fileRepository.createLocalFile(uniqueId, string, string2).andThen((CompletableSource)new StoryRepository().createLocalVideoStory(uniqueId, targetType, targetId, storyItems, metadata));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"FileRepository().createL\u2026a\n            )\n        )");
        return completable;
    }

    static /* synthetic */ Completable createLocalStory$default(CreateVideoStoryUseCase createVideoStoryUseCase, String string, AmityStory.TargetType targetType, String string2, Uri uri, List list, JsonObject jsonObject, int n, Object object) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return createVideoStoryUseCase.createLocalStory(string, targetType, string2, uri, list, jsonObject);
    }

    private final Single<AmityUploadResult<AmityVideo>> uploadFile(String referenceId, Uri fileUri) {
        Single single = new FileRepository().uploadVideo(referenceId, fileUri, AmityContentFeedType.STORY).lastOrError();
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"FileRepository().uploadV\u2026          ).lastOrError()");
        return single;
    }

    private final Completable createRemoteStory(String uniqueId, AmityStory.TargetType targetType, String targetId, String fileId, List<? extends AmityStoryItem> storyItems, JsonObject metadata) {
        Completable completable = new StoryRepository().createVideoStory(uniqueId, targetType, targetId, fileId, storyItems, metadata).andThen((CompletableSource)Completable.defer(() -> CreateVideoStoryUseCase.createRemoteStory$lambda-2(uniqueId, targetType, targetId)));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"StoryRepository().create\u2026      }\n                )");
        return completable;
    }

    static /* synthetic */ Completable createRemoteStory$default(CreateVideoStoryUseCase createVideoStoryUseCase, String string, AmityStory.TargetType targetType, String string2, String string3, List list, JsonObject jsonObject, int n, Object object) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return createVideoStoryUseCase.createRemoteStory(string, targetType, string2, string3, list, jsonObject);
    }

    private static final CompletableSource execute$lambda-1$lambda-0(CreateVideoStoryUseCase this$0, String $uniqueId, Throwable it) {
        CompletableSource completableSource;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uniqueId, (String)"$uniqueId");
        if (it instanceof AmityException) {
            completableSource = (CompletableSource)this$0.publishError($uniqueId, (AmityException)it);
        } else {
            AmityException unknownUploadError = AmityException.Companion.create$default(AmityException.Companion, "video file upload error", null, AmityError.UNKNOWN, null, 8, null);
            completableSource = (CompletableSource)this$0.publishError($uniqueId, unknownUploadError);
        }
        return completableSource;
    }

    private static final CompletableSource execute$lambda-1(CreateVideoStoryUseCase this$0, String $uniqueId, AmityStory.TargetType $targetType, String $targetId, List $storyItems, JsonObject $metadata, AmityUploadResult uploadResult) {
        CompletableSource completableSource;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uniqueId, (String)"$uniqueId");
        Intrinsics.checkNotNullParameter((Object)((Object)$targetType), (String)"$targetType");
        Intrinsics.checkNotNullParameter((Object)$targetId, (String)"$targetId");
        Intrinsics.checkNotNullParameter((Object)$storyItems, (String)"$storyItems");
        AmityUploadResult amityUploadResult = uploadResult;
        if (amityUploadResult instanceof AmityUploadResult.COMPLETE) {
            completableSource = (CompletableSource)this$0.createRemoteStory($uniqueId, $targetType, $targetId, ((AmityVideo)((AmityUploadResult.COMPLETE)uploadResult).getFile()).getFileId(), $storyItems, $metadata).onErrorResumeNext(arg_0 -> CreateVideoStoryUseCase.execute$lambda-1$lambda-0(this$0, $uniqueId, arg_0));
        } else if (amityUploadResult instanceof AmityUploadResult.ERROR) {
            completableSource = (CompletableSource)this$0.publishError($uniqueId, ((AmityUploadResult.ERROR)uploadResult).getError());
        } else {
            AmityException unknownUploadError = AmityException.Companion.create$default(AmityException.Companion, "video file upload error", null, AmityError.UNKNOWN, null, 8, null);
            completableSource = (CompletableSource)this$0.publishError($uniqueId, unknownUploadError);
        }
        return completableSource;
    }

    private static final CompletableSource createRemoteStory$lambda-2(String $uniqueId, AmityStory.TargetType $targetType, String $targetId) {
        Intrinsics.checkNotNullParameter((Object)$uniqueId, (String)"$uniqueId");
        Intrinsics.checkNotNullParameter((Object)((Object)$targetType), (String)"$targetType");
        Intrinsics.checkNotNullParameter((Object)$targetId, (String)"$targetId");
        return (CompletableSource)new StoryRepository().updateStorySyncState($uniqueId, AmityStory.State.SYNCED).andThen((CompletableSource)new StoryTargetRepository().updateStoryTargetLastStoryExpiresAt($targetType, $targetId, new StoryRepository().getHighestStoryExpiresAt($targetType, $targetId)));
    }
}

