/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.infra.upload;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import co.amity.rxupload.FileProperties;
import co.amity.rxupload.extension.UriKt;
import com.amity.socialcloud.sdk.core.data.file.RawFileModelMapper;
import com.amity.socialcloud.sdk.infra.upload.AmityUploadService;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.file.AmityRawFile;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadInfo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.ekoapp.ekosdk.internal.util.AppContext;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleEmitter;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001&B!\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001f\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J,\u0010\u0015\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u0014\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\"H\u0014J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u001c\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\"2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/amity/socialcloud/sdk/infra/upload/AmityImageUploadService;", "Lcom/amity/socialcloud/sdk/infra/upload/AmityUploadService;", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "Lcom/amity/socialcloud/sdk/model/core/file/AmityImage;", "uri", "Landroid/net/Uri;", "uploadId", "", "isFullImage", "", "(Landroid/net/Uri;Ljava/lang/String;Z)V", "deleteFile", "", "file", "Ljava/io/File;", "fixOrientation", "Landroid/graphics/Bitmap;", "bitmap", "orientation", "", "(Landroid/graphics/Bitmap;Ljava/lang/Integer;)Landroid/graphics/Bitmap;", "getFileAndOrientation", "Lio/reactivex/rxjava3/core/Single;", "Lkotlin/Pair;", "context", "Landroid/content/Context;", "fileUri", "getInputStream", "Ljava/io/InputStream;", "getUploadHeaders", "", "", "getUploadParams", "makeUploadServiceRequest", "Lio/reactivex/rxjava3/core/Flowable;", "rewriteImageFile", "saveMediaToCache", "uploadContentUri", "Builder", "amity-sdk_release"})
public final class AmityImageUploadService
extends AmityUploadService<AmityUploadResult<? extends AmityImage>> {
    @NotNull
    private final Uri uri;
    @Nullable
    private final String uploadId;
    private final boolean isFullImage;

    private AmityImageUploadService(Uri uri, String uploadId, boolean isFullImage) {
        this.uri = uri;
        this.uploadId = uploadId;
        this.isFullImage = isFullImage;
    }

    @Override
    @NotNull
    public Map<String, Object> getUploadParams() {
        return MapsKt.emptyMap();
    }

    @Override
    @NotNull
    public Map<String, Object> getUploadHeaders() {
        return MapsKt.emptyMap();
    }

    @Override
    @NotNull
    protected Flowable<AmityUploadResult<AmityImage>> makeUploadServiceRequest() {
        return this.uploadContentUri(this.uri);
    }

    private final Flowable<AmityUploadResult<AmityImage>> uploadContentUri(Uri uri) {
        Context context = AppContext.get();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"get()");
        Flowable flowable = this.rewriteImageFile(context, uri).flatMapPublisher(arg_0 -> AmityImageUploadService.uploadContentUri$lambda-4(this, arg_0)).onErrorReturn(AmityImageUploadService::uploadContentUri$lambda-5);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"rewriteImageFile(AppCont\u2026(exception)\n            }");
        return flowable;
    }

    private final Single<File> rewriteImageFile(Context context, Uri fileUri) {
        Single single = this.getFileAndOrientation(context, fileUri).flatMap(arg_0 -> AmityImageUploadService.rewriteImageFile$lambda-8(this, context, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"getFileAndOrientation(co\u2026bitmap)\n                }");
        return single;
    }

    private final InputStream getInputStream(Context context, Uri uri) {
        InputStream inputStream;
        if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content")) {
            File file = new File(uri.getPath());
            inputStream = new FileInputStream(file);
        } else {
            ContentResolver $this$getInputStream_u24lambda_u2d9 = context.getContentResolver();
            boolean bl = false;
            this.grantUriPermission(uri);
            $this$getInputStream_u24lambda_u2d9.takePersistableUriPermission(uri, 1);
            inputStream = $this$getInputStream_u24lambda_u2d9.openInputStream(uri);
        }
        return inputStream;
    }

    private final Single<Pair<File, Integer>> getFileAndOrientation(Context context, Uri fileUri) {
        Single single = Single.create(arg_0 -> AmityImageUploadService.getFileAndOrientation$lambda-13(context, this, fileUri, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"create { emitter ->\n    \u2026)\n            }\n        }");
        return single;
    }

    private final Bitmap fixOrientation(Bitmap bitmap, Integer orientation) {
        Bitmap bitmap2;
        try {
            Integer n;
            Matrix matrix = new Matrix();
            Integer n2 = n = orientation;
            int n3 = 1;
            if (n2 != null && n2 == n3) {
                return bitmap;
            }
            Integer n4 = n;
            n3 = 2;
            if (n4 != null && n4 == n3) {
                matrix.setScale(-1.0f, 1.0f);
            } else {
                Integer n5 = n;
                n3 = 3;
                if (n5 != null && n5 == n3) {
                    matrix.setRotate(180.0f);
                } else {
                    Integer n6 = n;
                    n3 = 4;
                    if (n6 != null && n6 == n3) {
                        matrix.setRotate(180.0f);
                        matrix.postScale(-1.0f, 1.0f);
                    } else {
                        Integer n7 = n;
                        n3 = 5;
                        if (n7 != null && n7 == n3) {
                            matrix.setRotate(90.0f);
                            matrix.postScale(-1.0f, 1.0f);
                        } else {
                            Integer n8 = n;
                            n3 = 6;
                            if (n8 != null && n8 == n3) {
                                matrix.setRotate(90.0f);
                            } else {
                                Integer n9 = n;
                                n3 = 7;
                                if (n9 != null && n9 == n3) {
                                    matrix.setRotate(-90.0f);
                                    matrix.postScale(-1.0f, 1.0f);
                                } else {
                                    Integer n10 = n;
                                    n3 = 8;
                                    if (n10 != null && n10 == n3) {
                                        matrix.setRotate(-90.0f);
                                    } else {
                                        return bitmap;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            Bitmap result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            bitmap.recycle();
            bitmap2 = result;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"{\n            val matrix\u2026         result\n        }");
        }
        catch (Exception e) {
            AmityLog.INSTANCE.e("Fail to rotate image with exception: " + e.getMessage(), new Object[0]);
            bitmap2 = bitmap;
        }
        return bitmap2;
    }

    private final Single<File> saveMediaToCache(Context context, Bitmap bitmap) {
        Single single = Single.create(arg_0 -> AmityImageUploadService.saveMediaToCache$lambda-16(context, bitmap, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"create<File> { emitter -\u2026)\n            }\n        }");
        return single;
    }

    private final void deleteFile(File file) {
        if (file.exists()) {
            boolean bl = file.delete();
        }
    }

    private static final AmityRawFile uploadContentUri$lambda-4$lambda-2$lambda-0(AmityImageUploadService this$0, FileProperties $fileProps) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        EkoFileEntity fileEntity = this$0.parseEkoFileEntity($fileProps.getResponseBody());
        fileEntity.setFilePath($fileProps.getUri().getPath());
        EkoFileDao fileDao = UserDatabase.get().fileDao();
        fileDao.insert((EkoObject)fileEntity);
        return new RawFileModelMapper().map(fileEntity);
    }

    private static final Publisher uploadContentUri$lambda-4$lambda-2$lambda-1(AmityRawFile it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (Publisher)Flowable.just(new AmityUploadResult.COMPLETE<AmityFileInfo>(new AmityImage(it)));
    }

    private static final Publisher uploadContentUri$lambda-4$lambda-2(AmityImageUploadService this$0, File $file, FileProperties fileProps) {
        Flowable flowable;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (fileProps.getProgress() == 100) {
            Intrinsics.checkNotNullExpressionValue((Object)$file, (String)"file");
            this$0.deleteFile($file);
            flowable = Single.fromCallable(() -> AmityImageUploadService.uploadContentUri$lambda-4$lambda-2$lambda-0(this$0, fileProps)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).flatMapPublisher(AmityImageUploadService::uploadContentUri$lambda-4$lambda-2$lambda-1);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)fileProps, (String)"fileProps");
            flowable = Flowable.just((Object)new AmityUploadResult.PROGRESS(new AmityUploadInfo(fileProps)));
        }
        return (Publisher)flowable;
    }

    private static final AmityUploadResult uploadContentUri$lambda-4$lambda-3(AmityImageUploadService this$0, File $file, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        AmityException exception = this$0.parseErrorResponse(it);
        Intrinsics.checkNotNullExpressionValue((Object)$file, (String)"file");
        this$0.deleteFile($file);
        return new AmityUploadResult.ERROR(exception);
    }

    private static final Publisher uploadContentUri$lambda-4(AmityImageUploadService this$0, File file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Uri bitmapUri = Uri.fromFile((File)file);
        Context context = AppContext.get();
        Map<String, Object> map = this$0.getUploadParams();
        Map<String, Object> map2 = this$0.getUploadHeaders();
        String string = this$0.uploadId;
        Intrinsics.checkNotNullExpressionValue((Object)bitmapUri, (String)"bitmapUri");
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"get()");
        return (Publisher)UriKt.upload((Uri)bitmapUri, (Context)context, (String)"api/v4/images", map2, map, (String)string, (String)"files").flatMap(arg_0 -> AmityImageUploadService.uploadContentUri$lambda-4$lambda-2(this$0, file, arg_0)).onErrorReturn(arg_0 -> AmityImageUploadService.uploadContentUri$lambda-4$lambda-3(this$0, file, arg_0));
    }

    private static final AmityUploadResult uploadContentUri$lambda-5(Throwable it) {
        AmityException exception = AmityException.Companion.create$default(AmityException.Companion, it.getMessage(), null, AmityError.UNKNOWN, null, 8, null);
        return new AmityUploadResult.ERROR(exception);
    }

    private static final SingleSource rewriteImageFile$lambda-8(AmityImageUploadService this$0, Context $context, Pair result) {
        Integer n;
        block3: {
            Bitmap bitmap;
            block2: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
                File file = (File)result.getFirst();
                Integer orientation = (Integer)result.getSecond();
                bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
                boolean bl = false;
                n = orientation;
                if (n == null) break block2;
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
                Bitmap bitmap2 = this$0.fixOrientation(bitmap, it);
                n = bitmap2;
                if (bitmap2 != null) break block3;
            }
            n = bitmap;
        }
        Integer bitmap = n;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return (SingleSource)this$0.saveMediaToCache($context, (Bitmap)bitmap);
    }

    private static final void getFileAndOrientation$lambda-13(Context $context, AmityImageUploadService this$0, Uri $fileUri, SingleEmitter emitter) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$fileUri, (String)"$fileUri");
        File file = new File($context.getCacheDir(), "img_cache_" + UUID.randomUUID() + ".jpg");
        try {
            Integer n;
            InputStream inputStream;
            try {
                Integer n2;
                if (Build.VERSION.SDK_INT >= 24) {
                    InputStream inputStream2 = this$0.getInputStream($context, $fileUri);
                    if (inputStream2 != null) {
                        inputStream = inputStream2;
                        boolean bl = false;
                        n2 = new ExifInterface(inputStream).getAttributeInt("Orientation", 1);
                    } else {
                        n2 = null;
                    }
                } else {
                    n2 = new ExifInterface(file.getAbsolutePath()).getAttributeInt("Orientation", 1);
                }
                n = n2;
            }
            catch (Exception e) {
                n = null;
            }
            Integer exifOrientation = n;
            InputStream inputStream3 = this$0.getInputStream($context, $fileUri);
            if (inputStream3 != null) {
                inputStream = inputStream3;
                boolean bl = false;
                FileOutputStream outputStream = new FileOutputStream(file);
                int read = 0;
                int maxBufferSize = 0x100000;
                int bytesAvailable = inputStream.available();
                int bufferSize = RangesKt.coerceAtMost((int)bytesAvailable, (int)maxBufferSize);
                byte[] buffers = new byte[bufferSize];
                while (true) {
                    int n3;
                    int it = n3 = inputStream.read(buffers);
                    boolean bl2 = false;
                    read = it;
                    if (n3 == -1) break;
                    outputStream.write(buffers, 0, read);
                }
                inputStream.close();
                outputStream.close();
                emitter.onSuccess((Object)new Pair((Object)file, (Object)exifOrientation));
            }
        }
        catch (Throwable e) {
            AmityLog.INSTANCE.e("Exception " + e.getMessage(), new Object[0]);
            emitter.onError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void saveMediaToCache$lambda-16(Context $context, Bitmap $bitmap, SingleEmitter emitter) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
        try {
            FileOutputStream fileOutputStream;
            String filename = "img_cache_" + UUID.randomUUID() + ".jpg";
            File file = Build.VERSION.SDK_INT > 28 ? new File($context.getCacheDir().getAbsolutePath() + File.separator + filename) : new File($context.getCacheDir(), filename);
            FileOutputStream $this$saveMediaToCache_u24lambda_u2d16_u24lambda_u2d15 = fileOutputStream = new FileOutputStream(file);
            boolean bl = false;
            Closeable closeable = $this$saveMediaToCache_u24lambda_u2d16_u24lambda_u2d15;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl2 = false;
                boolean bl3 = $bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$saveMediaToCache_u24lambda_u2d16_u24lambda_u2d15.close();
            emitter.onSuccess((Object)file);
        }
        catch (Throwable e) {
            AmityLog.INSTANCE.e("error: " + e, new Object[0]);
            emitter.onError(e);
        }
    }

    public /* synthetic */ AmityImageUploadService(Uri uri, String uploadId, boolean isFullImage, DefaultConstructorMarker $constructor_marker) {
        this(uri, uploadId, isFullImage);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\fJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/amity/socialcloud/sdk/infra/upload/AmityImageUploadService$Builder;", "", "()V", "isFullImage", "", "uploadId", "", "uri", "Landroid/net/Uri;", "build", "Lcom/amity/socialcloud/sdk/infra/upload/AmityImageUploadService;", "fileUri", "fileUri$amity_sdk_release", "amity-sdk_release"})
    public static final class Builder {
        private Uri uri;
        @Nullable
        private String uploadId;
        private boolean isFullImage;

        @NotNull
        public final Builder fileUri$amity_sdk_release(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
            return this;
        }

        @NotNull
        public final Builder uploadId(@NotNull String uploadId) {
            Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
            this.uploadId = uploadId;
            return this;
        }

        @NotNull
        public final Builder isFullImage(boolean isFullImage) {
            this.isFullImage = isFullImage;
            return this;
        }

        @NotNull
        public final AmityImageUploadService build() {
            Uri uri = this.uri;
            if (uri == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                uri = null;
            }
            return new AmityImageUploadService(uri, this.uploadId, this.isFullImage, null);
        }
    }
}

