/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.session;

import android.util.Log;
import co.amity.rxbridge.CompletableKt;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.data.notification.device.DeviceNotificationRepository;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister;
import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.amity.socialcloud.sdk.core.exception.EntityNotFoundException;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.model.core.user.UserUpdateOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.github.davidmoten.rx2.RetryWhen;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J*\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000bJ,\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/amity/socialcloud/sdk/core/data/session/SessionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "ABOUT_TO_EXPIRE_TRESHOLD", "", "activateAccount", "Lio/reactivex/rxjava3/core/Single;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "userId", "", "clearData", "Lio/reactivex/rxjava3/core/Completable;", "getActiveUserId", "getCurrentAccount", "login", "displayName", "authToken", "isLegacyVersion", "", "logout", "renewToken", "account", "renewTokenIfNeed", "updateDisplayNameIfNeeded", "", "verifyCurrentAccessToken", "amity-sdk_release"})
public final class SessionRepository
extends EkoObjectRepository {
    private final double ABOUT_TO_EXPIRE_TRESHOLD;

    public SessionRepository() {
        this.ABOUT_TO_EXPIRE_TRESHOLD = 0.8;
    }

    @NotNull
    public final String getActiveUserId() {
        return new SessionLocalDataStore().getActiveUserId();
    }

    @NotNull
    public final Completable login(@NotNull String userId, @Nullable String displayName, @Nullable String authToken, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = this.activateAccount(userId).flatMapCompletable(arg_0 -> SessionRepository.login$lambda-0(this, displayName, authToken, isLegacyVersion, arg_0)).doOnComplete(() -> SessionRepository.login$lambda-1(this, userId, displayName));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"activateAccount(userId)\n\u2026isplayName)\n            }");
        return completable;
    }

    @NotNull
    public final Completable logout() {
        return new DeviceNotificationRepository().unregisterAll();
    }

    @NotNull
    public final Completable clearData() {
        Completable completable = Completable.fromAction(SessionRepository::clearData$lambda-2).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026scribeOn(Schedulers.io())");
        return completable;
    }

    @NotNull
    public final Single<EkoAccount> getCurrentAccount() {
        Single single = Single.fromCallable(SessionRepository::getCurrentAccount$lambda-3).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fromCallable {\n         \u2026scribeOn(Schedulers.io())");
        return single;
    }

    @NotNull
    public final Completable renewToken(@NotNull EkoAccount account, @Nullable String displayName, @Nullable String authToken, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable(arg_0 -> SessionRepository.renewToken$lambda-8(account, displayName, authToken, isLegacyVersion, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"SessionLocalDataStore().\u2026   .toRx3()\n            }");
        return completable;
    }

    public static /* synthetic */ Completable renewToken$default(SessionRepository sessionRepository, EkoAccount ekoAccount, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return sessionRepository.renewToken(ekoAccount, string, string2, bl);
    }

    private final Single<EkoAccount> activateAccount(String userId) {
        Single single = Single.fromCallable(() -> SessionRepository.activateAccount$lambda-9(userId)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fromCallable {\n         \u2026scribeOn(Schedulers.io())");
        return single;
    }

    private final Completable renewTokenIfNeed(EkoAccount account, String displayName, String authToken, boolean isLegacyVersion) {
        Completable completable = this.verifyCurrentAccessToken(account).onErrorResumeNext(arg_0 -> SessionRepository.renewTokenIfNeed$lambda-10(this, account, displayName, authToken, isLegacyVersion, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"verifyCurrentAccessToken\u2026          }\n            }");
        return completable;
    }

    private final Completable verifyCurrentAccessToken(EkoAccount account) {
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable(arg_0 -> SessionRepository.verifyCurrentAccessToken$lambda-11(account, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"SessionLocalDataStore().\u2026          }\n            }");
        return completable;
    }

    private final void updateDisplayNameIfNeeded(String userId, String displayName) {
        if (displayName != null) {
            new UserRepository().observe(userId).firstOrError().flatMapCompletable(arg_0 -> SessionRepository.updateDisplayNameIfNeeded$lambda-12(displayName, userId, arg_0)).subscribeOn(Schedulers.io()).doOnError(SessionRepository::updateDisplayNameIfNeeded$lambda-13).subscribe();
        }
    }

    private static final CompletableSource login$lambda-0(SessionRepository this$0, String $displayName, String $authToken, boolean $isLegacyVersion, EkoAccount it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)this$0.renewTokenIfNeed(it, $displayName, $authToken, $isLegacyVersion);
    }

    private static final void login$lambda-1(SessionRepository this$0, String $userId, String $displayName) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        this$0.updateDisplayNameIfNeeded($userId, $displayName);
    }

    private static final void clearData$lambda-2() {
        new SessionLocalDataStore().logoutAccount(new SessionLocalDataStore().getActiveUserId());
    }

    private static final EkoAccount getCurrentAccount$lambda-3() {
        EkoAccount account = new SessionLocalDataStore().getCurrentAccount();
        if (account != null) {
            return account;
        }
        throw EntityNotFoundException.INSTANCE;
    }

    private static final CompletableSource renewToken$lambda-8$lambda-5(EkoAccount $account, boolean $isLegacyVersion, SessionRepository this$0, RegisterDeviceDto it) {
        EkoUserListDto ekoUserListDto;
        Intrinsics.checkNotNullParameter((Object)$account, (String)"$account");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $account.setRefreshToken(it.getRefreshToken());
        $account.setAccessToken(it.getAccessToken());
        if ($isLegacyVersion) {
            $account.setIssuedAt(DateTime.now());
            $account.setExpiresAt(DateTime.now().plus((ReadableDuration)Duration.standardDays((long)365L)));
        } else {
            $account.setIssuedAt(it.getIssuedAt());
            $account.setExpiresAt(it.getExpiresAt());
        }
        double tokenDuration = (double)($account.getExpiresAt().getMillis() - $account.getIssuedAt().getMillis() - (long)CoreClient.INSTANCE.getMillisTimeDiff$amity_sdk_release()) * this$0.ABOUT_TO_EXPIRE_TRESHOLD;
        $account.setAboutToExpireAt($account.getIssuedAt().plus((long)tokenDuration));
        Log.e((String)"SSM3", (String)("token renewed: account updated : \n       expiresAt = " + $account.getExpiresAt() + " \naboutToExpireAt = " + $account.getAboutToExpireAt() + "\n       issuedAt = " + $account.getIssuedAt() + "\nduration: = " + tokenDuration / (double)1000 + " sec "));
        EkoUserListDto $this$renewToken_u24lambda_u2d8_u24lambda_u2d5_u24lambda_u2d4 = ekoUserListDto = new EkoUserListDto();
        boolean bl = false;
        List list = it.getUsers();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        $this$renewToken_u24lambda_u2d8_u24lambda_u2d5_u24lambda_u2d4.setUsers(list);
        List list2 = it.getFiles();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        $this$renewToken_u24lambda_u2d8_u24lambda_u2d5_u24lambda_u2d4.setFiles(list2);
        EkoUserListDto users = ekoUserListDto;
        return (CompletableSource)new SessionLocalDataStore().updateAccount($account).andThen((CompletableSource)new UserQueryPersister().persist(users));
    }

    private static final boolean renewToken$lambda-8$lambda-6(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AmityError.Companion.from(it) != AmityError.USER_IS_GLOBAL_BANNED;
    }

    private static final void renewToken$lambda-8$lambda-7(EkoAccount $account, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$account, (String)"$account");
        SessionLocalDataStore sessionLocalDataStore = new SessionLocalDataStore();
        String string = $account.getUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"account.userId");
        sessionLocalDataStore.logoutAccount(string);
    }

    private static final CompletableSource renewToken$lambda-8(EkoAccount $account, String $displayName, String $authToken, boolean $isLegacyVersion, SessionRepository this$0, EkoApiKey it) {
        Intrinsics.checkNotNullParameter((Object)$account, (String)"$account");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
        String string = it.getApiKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiKey");
        String string2 = $account.getUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"account.userId");
        String string3 = $account.getDeviceId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"account.deviceId");
        Completable completable = sessionRemoteDataStore.registerDevice(string, string2, $displayName, string3, $authToken, $isLegacyVersion).flatMapCompletable(arg_0 -> SessionRepository.renewToken$lambda-8$lambda-5($account, $isLegacyVersion, this$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"SessionRemoteDataStore()\u2026s))\n                    }");
        io.reactivex.Completable completable2 = CompletableKt.toRx2((Completable)completable).retryWhen(RetryWhen.retryIf(SessionRepository::renewToken$lambda-8$lambda-6).maxRetries(3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).build()).doOnError(arg_0 -> SessionRepository.renewToken$lambda-8$lambda-7($account, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"SessionRemoteDataStore()\u2026Id)\n                    }");
        return (CompletableSource)CompletableKt.toRx3((io.reactivex.Completable)completable2);
    }

    private static final EkoAccount activateAccount$lambda-9(String $userId) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        return new SessionLocalDataStore().activateAccount($userId);
    }

    private static final CompletableSource renewTokenIfNeed$lambda-10(SessionRepository this$0, EkoAccount $account, String $displayName, String $authToken, boolean $isLegacyVersion, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$account, (String)"$account");
        return AmityError.Companion.from(it) == AmityError.USER_IS_GLOBAL_BANNED ? (CompletableSource)Completable.error((Throwable)it) : (CompletableSource)this$0.renewToken($account, $displayName, $authToken, $isLegacyVersion);
    }

    private static final CompletableSource verifyCurrentAccessToken$lambda-11(EkoAccount $account, EkoApiKey it) {
        CompletableSource completableSource;
        Intrinsics.checkNotNullParameter((Object)$account, (String)"$account");
        if ($account.getAccessToken() == null) {
            completableSource = (CompletableSource)Completable.error((Throwable)AmityException.Companion.create("accessToken not found", null, AmityError.UNAUTHORIZED_ERROR));
        } else {
            SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
            String string = it.getApiKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiKey");
            completableSource = (CompletableSource)sessionRemoteDataStore.verifyAccessToken(string);
        }
        return completableSource;
    }

    private static final CompletableSource updateDisplayNameIfNeeded$lambda-12(String $displayName, String $userId, AmityUser it) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        return Intrinsics.areEqual((Object)it.getDisplayName(), (Object)$displayName) ? (CompletableSource)Completable.complete() : (CompletableSource)new UserRepository().updateUser($userId, new UserUpdateOption($displayName, null, null, null, null, null, null, 126, null)).ignoreElement();
    }

    private static final void updateDisplayNameIfNeeded$lambda-13(Throwable it) {
    }
}

