/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.message;

import android.net.Uri;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuerySortOption;
import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerRepository;
import com.amity.socialcloud.sdk.chat.data.message.MessageLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageModelMapper;
import com.amity.socialcloud.sdk.chat.data.message.MessageQueryPersister;
import com.amity.socialcloud.sdk.chat.data.message.MessageRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.message.paging.MessageMediator;
import com.amity.socialcloud.sdk.chat.domain.marker.message.OptimisticCreateMessageMarkerUseCase;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.MarkerSyncEngine;
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore;
import com.amity.socialcloud.sdk.core.data.file.FileRepository;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage;
import com.amity.socialcloud.sdk.model.core.content.AmityContentFeedType;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto;
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto;
import com.ekoapp.ekosdk.internal.data.model.EkoQueryToken;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.repository.comment.CommentLoadResult;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 O2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001OB\u0005\u00a2\u0006\u0002\u0010\u0004JR\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\\\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bJ\b\u0010\u001f\u001a\u00020 H\u0002J_\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010$2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020 \u00a2\u0006\u0002\u0010+J]\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030-0\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010$2\u0006\u0010.\u001a\u00020/2\b\u0010\f\u001a\u0004\u0018\u000100\u00a2\u0006\u0002\u00101Jj\u00102\u001a\u00020\u0006\"\b\b\u0000\u00103*\u0002042\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u00105\u001a\b\u0012\u0004\u0012\u0002H306H\u0002J\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020$0\u00162\u0006\u0010\u0018\u001a\u00020\bJ_\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010.\u001a\u00020/2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010:\u001a\u00020 \u00a2\u0006\u0002\u0010;J_\u0010<\u001a\b\u0012\u0004\u0012\u0002090\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010.\u001a\u00020/2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010=\u001a\u00020\b\u00a2\u0006\u0002\u0010>J\u0014\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030@H\u0016J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00020\"2\u0006\u0010\u001a\u001a\u00020\bH\u0016J#\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010CJ]\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00130\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010$2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010.\u001a\u00020/\u00a2\u0006\u0002\u0010EJ\u0012\u0010F\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\bH\u0016J^\u0010G\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u000e\u0010I\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bJ\u001d\u0010J\u001a\u00020K2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010L\u001a\u00020 H\u0000\u00a2\u0006\u0002\bMJ<\u0010N\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013\u00a8\u0006P"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/message/MessageRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage;", "()V", "createMessage", "Lio/reactivex/rxjava3/core/Completable;", "subChannelId", "", "parentId", "fileUri", "Landroid/net/Uri;", "type", "data", "Lcom/google/gson/JsonObject;", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "metadata", "mentionees", "", "Lcom/amity/socialcloud/sdk/model/core/mention/AmityMentioneeTarget;", "createPreviewMessage", "Lio/reactivex/rxjava3/core/Single;", "deleteMessage", "messageId", "fetchAndSave", "objectId", "fetchMessageMarker", "dto", "Lcom/ekoapp/ekosdk/internal/api/dto/MessageQueryDto;", "flagMessage", "getDefaultPageSize", "", "getLatestMessage", "Lio/reactivex/rxjava3/core/Flowable;", "isFilterByParentId", "", "includingTags", "excludingTags", "isDeleted", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Ljava/lang/String;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "getMessagePagingData", "Landroidx/paging/PagingData;", "sortOption", "Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;)Lio/reactivex/rxjava3/core/Flowable;", "handleUploadResult", "T", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFileInfo;", "uploadResult", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "isFlaggedByMe", "loadFirstPageMessages", "Lcom/ekoapp/ekosdk/internal/repository/comment/CommentLoadResult;", "limit", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Ljava/lang/String;ZLjava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;I)Lio/reactivex/rxjava3/core/Single;", "loadMessages", "token", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Ljava/lang/String;ZLjava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Single;", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "observeLatestMessage", "(Ljava/lang/String;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Flowable;", "observeMessages", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;)Lio/reactivex/rxjava3/core/Flowable;", "queryFromCache", "syncMessage", "fileId", "unflagMessage", "updateMarkerHash", "", "hash", "updateMarkerHash$amity_sdk_release", "updateMessage", "Companion", "amity-sdk_release"})
public final class MessageRepository
extends AmityObjectRepository<EkoMessageEntity, AmityMessage> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<AmityMessage.DataType> fileUploadingTypes;

    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new MessageRemoteDataStore().getMessage(objectId).flatMapCompletable(arg_0 -> MessageRepository.fetchAndSave$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageRemoteDataStore()\u2026rsist(dto))\n            }");
        return completable;
    }

    @Override
    @Nullable
    public EkoMessageEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        EkoMessageEntity message = new MessageLocalDataStore().getMessage(objectId);
        if (message != null && AmityMessage.State.Companion.enumOf(message.getSyncState()) != AmityMessage.State.SYNCED) {
            throw AmityException.Companion.create("Observing unsynced object is not supported by Live Object.", null, AmityError.UNSUPPORTED);
        }
        return message;
    }

    @Override
    @NotNull
    public ModelMapper<EkoMessageEntity, AmityMessage> mapper() {
        return new MessageModelMapper();
    }

    @Override
    @NotNull
    public Flowable<EkoMessageEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new MessageLocalDataStore().observeMessage(objectId);
    }

    private final int getDefaultPageSize() {
        return 20;
    }

    @NotNull
    public final Completable createMessage(@NotNull String subChannelId, @Nullable String parentId, @Nullable Uri fileUri, @NotNull String type, @NotNull JsonObject data, @NotNull AmityTags tags, @Nullable JsonObject metadata, @NotNull List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter(mentionees, (String)"mentionees");
        Completable completable = this.createPreviewMessage(subChannelId, parentId, type, data, tags, fileUri, metadata, mentionees).flatMapCompletable(arg_0 -> MessageRepository.createMessage$lambda-5(type, this, subChannelId, parentId, data, tags, metadata, mentionees, fileUri, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"createPreviewMessage(\n  \u2026          }\n            }");
        return completable;
    }

    private final <T extends AmityFileInfo> Completable handleUploadResult(String messageId, String subChannelId, String parentId, String type, JsonObject data, AmityTags tags, JsonObject metadata, List<AmityMentioneeTarget> mentionees, AmityUploadResult<? extends T> uploadResult) {
        Completable completable;
        AmityUploadResult<? extends T> amityUploadResult = uploadResult;
        if (amityUploadResult instanceof AmityUploadResult.COMPLETE) {
            String fileId = ((AmityFileInfo)((AmityUploadResult.COMPLETE)uploadResult).getFile()).getFileId();
            completable = this.syncMessage(messageId, subChannelId, parentId, type, data, tags, fileId, metadata, mentionees);
        } else if (amityUploadResult instanceof AmityUploadResult.ERROR) {
            Completable completable2 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)((AmityUploadResult.ERROR)uploadResult).getError()));
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n                Messag\u2026etError()))\n            }");
            completable = completable2;
        } else if (amityUploadResult instanceof AmityUploadResult.CANCELLED) {
            Completable completable3 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)AmityException.Companion.create(StringsKt.capitalize((String)type) + " upload cancelled", null, AmityError.UNKNOWN)));
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"{\n                Messag\u2026          )\n            }");
        } else {
            Completable completable4 = Completable.complete();
            completable = completable4;
            Intrinsics.checkNotNullExpressionValue((Object)completable4, (String)"{\n                Comple\u2026.complete()\n            }");
        }
        return completable;
    }

    private final Completable syncMessage(String messageId, String subChannelId, String parentId, String type, JsonObject data, AmityTags tags, String fileId, JsonObject metadata, List<AmityMentioneeTarget> mentionees) {
        if (data.has("fileId")) {
            data.remove("fileId");
        }
        Completable completable = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.SYNCING).andThen((CompletableSource)new MessageRemoteDataStore().createMessage(messageId, parentId, subChannelId, fileId, type, data, tags, metadata, mentionees).flatMapCompletable(arg_0 -> MessageRepository.syncMessage$lambda-6(messageId, arg_0))).onErrorResumeNext(arg_0 -> MessageRepository.syncMessage$lambda-7(messageId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageLocalDataStore().\u2026.error(it))\n            }");
        return completable;
    }

    static /* synthetic */ Completable syncMessage$default(MessageRepository messageRepository, String string, String string2, String string3, String string4, JsonObject jsonObject, AmityTags amityTags, String string5, JsonObject jsonObject2, List list, int n, Object object) {
        if ((n & 0x40) != 0) {
            string5 = null;
        }
        return messageRepository.syncMessage(string, string2, string3, string4, jsonObject, amityTags, string5, jsonObject2, list);
    }

    private final Single<EkoMessageEntity> createPreviewMessage(String subChannelId, String parentId, String type, JsonObject data, AmityTags tags, Uri fileUri, JsonObject metadata, List<AmityMentioneeTarget> mentionees) {
        Single single = new MessageLocalDataStore().createMessage(subChannelId, parentId, type, data, metadata, tags, fileUri, mentionees).flatMap(arg_0 -> MessageRepository.createPreviewMessage$lambda-8(fileUri, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"MessageLocalDataStore().\u2026.just(message))\n        }");
        return single;
    }

    @NotNull
    public final Flowable<AmityMessage> observeLatestMessage(@NotNull String subChannelId, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Flowable flowable = new MessageLocalDataStore().observeLatestMessage(subChannelId, isDeleted).map(MessageRepository::observeLatestMessage$lambda-9);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"MessageLocalDataStore().\u2026r().map(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Completable updateMessage(@NotNull String messageId, @Nullable JsonObject data, @Nullable AmityTags tags, @Nullable JsonObject metadata, @Nullable List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MessageRemoteDataStore().updateMessage(messageId, data, tags, metadata, mentionees).flatMapCompletable(MessageRepository::updateMessage$lambda-10);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageRemoteDataStore()\u2026persist(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable deleteMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = Single.fromCallable(() -> MessageRepository.deleteMessage$lambda-11(messageId)).flatMapCompletable(arg_0 -> MessageRepository.deleteMessage$lambda-13(messageId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromCallable {\n         \u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Completable flagMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MessageFlagRemoteDataStore().flagMessage(messageId).map(MessageRepository::flagMessage$lambda-14).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageFlagRemoteDataSto\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable unflagMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MessageFlagRemoteDataStore().unflagMessage(messageId).map(MessageRepository::unflagMessage$lambda-15).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"MessageFlagRemoteDataSto\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Flowable<List<AmityMessage>> observeMessages(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @Nullable String type, @NotNull AmityMessageQuerySortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Flowable flowable = new MessageLocalDataStore().observeMessages(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, type, sortOption).map(MessageRepository::observeMessages$lambda-17);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"MessageLocalDataStore().\u2026)\n            }\n        }");
        return flowable;
    }

    @NotNull
    public final Single<CommentLoadResult> loadFirstPageMessages(@NotNull String subChannelId, @NotNull AmityMessageQuerySortOption sortOption, @Nullable String parentId, boolean isFilterByParentId, @Nullable Boolean isDeleted, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable String type, int limit) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        MessageRemoteDataStore messageRemoteDataStore = new MessageRemoteDataStore();
        String string = sortOption.getApiKey();
        Single single = MessageRemoteDataStore.queryMessages$default(messageRemoteDataStore, subChannelId, isFilterByParentId, parentId, isDeleted, includingTags, excludingTags, type, limit, string, null, 512, null).flatMap(arg_0 -> MessageRepository.loadFirstPageMessages$lambda-18(subChannelId, this, arg_0)).map(MessageRepository::loadFirstPageMessages$lambda-20);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"MessageRemoteDataStore()\u2026token, ids)\n            }");
        return single;
    }

    @NotNull
    public final Single<CommentLoadResult> loadMessages(@NotNull String subChannelId, @NotNull AmityMessageQuerySortOption sortOption, @Nullable String parentId, boolean isFilterByParentId, @Nullable Boolean isDeleted, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable String type, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Single single = MessageRemoteDataStore.queryMessages$default(new MessageRemoteDataStore(), subChannelId, isFilterByParentId, parentId, isDeleted, includingTags, excludingTags, type, null, sortOption.getApiKey(), token, 128, null).flatMap(arg_0 -> MessageRepository.loadMessages$lambda-21(this, arg_0)).map(MessageRepository::loadMessages$lambda-23);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"MessageRemoteDataStore()\u2026token, ids)\n            }");
        return single;
    }

    @NotNull
    public final Flowable<PagingData<AmityMessage>> getMessagePagingData(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @NotNull AmityMessageQuerySortOption sortOption, @Nullable AmityMessage.DataType type) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        int n = this.getDefaultPageSize();
        int n2 = this.getDefaultPageSize() / 2;
        AmityMessage.DataType dataType = type;
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(n, 0, true, n2, 0, 0, 48, null), null, new MessageMediator(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, sortOption, dataType != null ? dataType.getApiKey() : null), (Function0)new Function0<PagingSource<Integer, EkoMessageEntity>>(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, sortOption, type){
            final /* synthetic */ String $subChannelId;
            final /* synthetic */ boolean $isFilterByParentId;
            final /* synthetic */ String $parentId;
            final /* synthetic */ AmityTags $includingTags;
            final /* synthetic */ AmityTags $excludingTags;
            final /* synthetic */ Boolean $isDeleted;
            final /* synthetic */ AmityMessageQuerySortOption $sortOption;
            final /* synthetic */ AmityMessage.DataType $type;
            {
                this.$subChannelId = $subChannelId;
                this.$isFilterByParentId = $isFilterByParentId;
                this.$parentId = $parentId;
                this.$includingTags = $includingTags;
                this.$excludingTags = $excludingTags;
                this.$isDeleted = $isDeleted;
                this.$sortOption = $sortOption;
                this.$type = $type;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, EkoMessageEntity> invoke() {
                AmityMessage.DataType dataType = this.$type;
                return new MessageLocalDataStore().getMessagePagingSource(this.$subChannelId, this.$isFilterByParentId, this.$parentId, this.$includingTags, this.$excludingTags, this.$isDeleted, this.$sortOption, dataType != null ? dataType.getApiKey() : null);
            }
        }, (ModelMapper)new MessageModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<AmityMessage> getLatestMessage(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @Nullable String type, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new MessageLocalDataStore().getLatestMessage(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, type, dynamicQueryStreamKeyCreator, nonce).map(MessageRepository::getLatestMessage$lambda-24);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"MessageLocalDataStore().\u2026r().map(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Single<Boolean> isFlaggedByMe(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Single single = new MessageFlagRemoteDataStore().isFlaggedByMe(messageId).map(MessageRepository::isFlaggedByMe$lambda-25);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"MessageFlagRemoteDataSto\u2026\"isFlagByMe\").asBoolean }");
        return single;
    }

    public final void updateMarkerHash$amity_sdk_release(@NotNull String messageId, int hash) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        new MessageLocalDataStore().updateMarkerHash(messageId, hash);
    }

    /*
     * WARNING - void declaration
     */
    private final Completable fetchMessageMarker(MessageQueryDto dto) {
        void $this$mapTo$iv$iv;
        EkoMessageDto it;
        Iterable $this$filterTo$iv$iv;
        List<EkoMessageDto> list = dto.getMessages();
        Intrinsics.checkNotNullExpressionValue(list, (String)"dto.messages");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (EkoMessageDto)element$iv$iv;
            boolean bl = false;
            if (!MarkerSyncEngine.Companion.isMarkerSyncSupport(it.getChannelType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (EkoMessageDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMessageId());
        }
        List messageIds = (List)destination$iv$iv;
        boolean bl = false;
        Completable completable = (messageIds.isEmpty() ? Completable.complete() : new MessageMarkerRepository().fetchMessageMarker(messageIds)).onErrorComplete();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"dto.messages\n           \u2026       .onErrorComplete()");
        return completable;
    }

    private static final CompletableSource fetchAndSave$lambda-0(MessageRepository this$0, MessageQueryDto dto) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)dto, (String)"dto");
        return (CompletableSource)this$0.fetchMessageMarker(dto).andThen((CompletableSource)new MessageQueryPersister().persist(dto));
    }

    private static final CompletableSource createMessage$lambda-5$lambda-1(MessageRepository this$0, String $messageId, String $subChannelId, String $parentId, String $type, JsonObject $data, AmityTags $tags, JsonObject $metadata, List $mentionees, AmityUploadResult it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        Intrinsics.checkNotNullParameter((Object)$subChannelId, (String)"$subChannelId");
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$tags, (String)"$tags");
        Intrinsics.checkNotNullParameter((Object)$mentionees, (String)"$mentionees");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)this$0.handleUploadResult($messageId, $subChannelId, $parentId, $type, $data, $tags, $metadata, $mentionees, it);
    }

    private static final CompletableSource createMessage$lambda-5$lambda-2(MessageRepository this$0, String $messageId, String $subChannelId, String $parentId, String $type, JsonObject $data, AmityTags $tags, JsonObject $metadata, List $mentionees, AmityUploadResult it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        Intrinsics.checkNotNullParameter((Object)$subChannelId, (String)"$subChannelId");
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$tags, (String)"$tags");
        Intrinsics.checkNotNullParameter((Object)$mentionees, (String)"$mentionees");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)this$0.handleUploadResult($messageId, $subChannelId, $parentId, $type, $data, $tags, $metadata, $mentionees, it);
    }

    private static final CompletableSource createMessage$lambda-5$lambda-3(MessageRepository this$0, String $messageId, String $subChannelId, String $parentId, String $type, JsonObject $data, AmityTags $tags, JsonObject $metadata, List $mentionees, AmityUploadResult it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        Intrinsics.checkNotNullParameter((Object)$subChannelId, (String)"$subChannelId");
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$tags, (String)"$tags");
        Intrinsics.checkNotNullParameter((Object)$mentionees, (String)"$mentionees");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)this$0.handleUploadResult($messageId, $subChannelId, $parentId, $type, $data, $tags, $metadata, $mentionees, it);
    }

    private static final CompletableSource createMessage$lambda-5$lambda-4(MessageRepository this$0, String $messageId, String $subChannelId, String $parentId, String $type, JsonObject $data, AmityTags $tags, JsonObject $metadata, List $mentionees, AmityUploadResult it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        Intrinsics.checkNotNullParameter((Object)$subChannelId, (String)"$subChannelId");
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$tags, (String)"$tags");
        Intrinsics.checkNotNullParameter((Object)$mentionees, (String)"$mentionees");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)this$0.handleUploadResult($messageId, $subChannelId, $parentId, $type, $data, $tags, $metadata, $mentionees, it);
    }

    private static final CompletableSource createMessage$lambda-5(String $type, MessageRepository this$0, String $subChannelId, String $parentId, JsonObject $data, AmityTags $tags, JsonObject $metadata, List $mentionees, Uri $fileUri, EkoMessageEntity it) {
        CompletableSource completableSource;
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$subChannelId, (String)"$subChannelId");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$tags, (String)"$tags");
        Intrinsics.checkNotNullParameter((Object)$mentionees, (String)"$mentionees");
        String messageId = it.getMessageId();
        AmityMessage.DataType dataType = AmityMessage.DataType.Companion.enumOf($type);
        boolean hasUploadState = fileUploadingTypes.contains((Object)dataType);
        if (!hasUploadState) {
            completableSource = (CompletableSource)MessageRepository.syncMessage$default(this$0, messageId, $subChannelId, $parentId, $type, $data, $tags, null, $metadata, $mentionees, 64, null);
        } else {
            Completable completable;
            Completable completable2 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.UPLOADING);
            switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                case 1: {
                    FileRepository fileRepository = new FileRepository();
                    Uri uri = $fileUri;
                    Intrinsics.checkNotNull((Object)uri);
                    completable = fileRepository.uploadImage(messageId, uri).flatMapCompletable(arg_0 -> MessageRepository.createMessage$lambda-5$lambda-1(this$0, messageId, $subChannelId, $parentId, $type, $data, $tags, $metadata, $mentionees, arg_0));
                    break;
                }
                case 2: {
                    FileRepository fileRepository = new FileRepository();
                    Uri uri = $fileUri;
                    Intrinsics.checkNotNull((Object)uri);
                    completable = fileRepository.uploadFile(messageId, uri).flatMapCompletable(arg_0 -> MessageRepository.createMessage$lambda-5$lambda-2(this$0, messageId, $subChannelId, $parentId, $type, $data, $tags, $metadata, $mentionees, arg_0));
                    break;
                }
                case 3: {
                    FileRepository fileRepository = new FileRepository();
                    Uri uri = $fileUri;
                    Intrinsics.checkNotNull((Object)uri);
                    completable = fileRepository.uploadAudio(messageId, uri).flatMapCompletable(arg_0 -> MessageRepository.createMessage$lambda-5$lambda-3(this$0, messageId, $subChannelId, $parentId, $type, $data, $tags, $metadata, $mentionees, arg_0));
                    break;
                }
                case 4: {
                    FileRepository fileRepository = new FileRepository();
                    Uri uri = $fileUri;
                    Intrinsics.checkNotNull((Object)uri);
                    completable = fileRepository.uploadVideo(messageId, uri, AmityContentFeedType.MESSAGE).flatMapCompletable(arg_0 -> MessageRepository.createMessage$lambda-5$lambda-4(this$0, messageId, $subChannelId, $parentId, $type, $data, $tags, $metadata, $mentionees, arg_0));
                    break;
                }
                default: {
                    completable = Completable.complete();
                }
            }
            completableSource = (CompletableSource)completable2.andThen((CompletableSource)completable);
        }
        return completableSource;
    }

    private static final CompletableSource syncMessage$lambda-6(String $messageId, MessageQueryDto it) {
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        OptimisticCreateMessageMarkerUseCase optimisticCreateMessageMarkerUseCase = new OptimisticCreateMessageMarkerUseCase();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)optimisticCreateMessageMarkerUseCase.execute(it).onErrorComplete().andThen((CompletableSource)new MessageQueryPersister().persist(it)).andThen((CompletableSource)new MessageLocalDataStore().updateMessageState($messageId, AmityMessage.State.SYNCED));
    }

    private static final CompletableSource syncMessage$lambda-7(String $messageId, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        return (CompletableSource)new MessageLocalDataStore().updateMessageState($messageId, AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)it));
    }

    private static final SingleSource createPreviewMessage$lambda-8(Uri $fileUri, EkoMessageEntity message) {
        Completable completable;
        Completable completable2 = new MessageFlagLocalDataStore().createFlag(message.getMessageId());
        if (!fileUploadingTypes.contains((Object)message.getDataType())) {
            completable = Completable.complete();
        } else {
            Object object;
            String fileType;
            switch (WhenMappings.$EnumSwitchMapping$0[message.getDataType().ordinal()]) {
                case 1: {
                    String string = AmityMessage.DataType.IMAGE.getApiKey();
                    break;
                }
                case 4: {
                    String string = AmityMessage.DataType.VIDEO.getApiKey();
                    break;
                }
                case 3: {
                    String string = AmityMessage.DataType.AUDIO.getApiKey();
                    break;
                }
                default: {
                    String string = fileType = AmityMessage.DataType.FILE.getApiKey();
                }
            }
            if ((object = $fileUri) == null || (object = object.getPath()) == null) {
                object = "";
            }
            Object path = object;
            completable = new FileLocalDataStore().createLocalFile(message.getMessageId(), fileType, (String)path);
        }
        return (SingleSource)completable2.andThen((CompletableSource)completable).andThen((SingleSource)Single.just((Object)message));
    }

    private static final AmityMessage observeLatestMessage$lambda-9(EkoMessageEntity it) {
        MessageModelMapper messageModelMapper = new MessageModelMapper();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return messageModelMapper.map(it);
    }

    private static final CompletableSource updateMessage$lambda-10(MessageQueryDto it) {
        MessageQueryPersister messageQueryPersister = new MessageQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)messageQueryPersister.persist(it);
    }

    private static final String deleteMessage$lambda-11(String $messageId) {
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        String deletingId = "";
        EkoMessageEntity message = new MessageLocalDataStore().getMessage($messageId);
        if (message == null || Intrinsics.areEqual((Object)message.getSyncState(), (Object)AmityMessage.State.SYNCED.getStateName())) {
            deletingId = $messageId;
        }
        return deletingId;
    }

    private static final CompletableSource deleteMessage$lambda-13$lambda-12(MessageQueryDto it) {
        MessageQueryPersister messageQueryPersister = new MessageQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (CompletableSource)messageQueryPersister.persist(it);
    }

    private static final CompletableSource deleteMessage$lambda-13(String $messageId, String deletingId) {
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        Intrinsics.checkNotNullExpressionValue((Object)deletingId, (String)"deletingId");
        return ((CharSequence)deletingId).length() > 0 ? (CompletableSource)new MessageRemoteDataStore().deleteMessage($messageId).flatMapCompletable(MessageRepository::deleteMessage$lambda-13$lambda-12) : (CompletableSource)new MessageLocalDataStore().hardDeleteMessage($messageId);
    }

    private static final Completable flagMessage$lambda-14(MessageQueryDto it) {
        MessageQueryPersister messageQueryPersister = new MessageQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return messageQueryPersister.persist(it);
    }

    private static final Completable unflagMessage$lambda-15(MessageQueryDto it) {
        MessageQueryPersister messageQueryPersister = new MessageQueryPersister();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return messageQueryPersister.persist(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final List observeMessages$lambda-17(List it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Iterable $this$map$iv = it;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            EkoMessageEntity ekoMessageEntity = (EkoMessageEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MessageModelMapper().map((EkoMessageEntity)it2));
        }
        return (List)destination$iv$iv;
    }

    private static final SingleSource loadFirstPageMessages$lambda-18(String $subChannelId, MessageRepository this$0, MessageQueryDto it) {
        Intrinsics.checkNotNullParameter((Object)$subChannelId, (String)"$subChannelId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Completable completable = new MessageLocalDataStore().hardDeleteAllFromSubChannel($subChannelId);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (SingleSource)completable.andThen((CompletableSource)this$0.fetchMessageMarker(it)).andThen((CompletableSource)new MessageQueryPersister().persist(it)).andThen((SingleSource)Single.just((Object)it));
    }

    /*
     * WARNING - void declaration
     */
    private static final CommentLoadResult loadFirstPageMessages$lambda-20(MessageQueryDto dto) {
        void $this$mapTo$iv$iv;
        List<EkoMessageDto> list = dto.getMessages();
        Intrinsics.checkNotNullExpressionValue(list, (String)"dto.messages");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EkoMessageDto ekoMessageDto = (EkoMessageDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMessageId());
        }
        List ids = (List)destination$iv$iv;
        Object object = dto.getToken();
        if (object == null || (object = ((EkoQueryToken)object).getNext()) == null) {
            object = "";
        }
        Object token = object;
        return new CommentLoadResult((String)token, ids);
    }

    private static final SingleSource loadMessages$lambda-21(MessageRepository this$0, MessageQueryDto dto) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)dto, (String)"dto");
        return (SingleSource)this$0.fetchMessageMarker(dto).andThen((CompletableSource)new MessageQueryPersister().persist(dto)).andThen((SingleSource)Single.just((Object)dto));
    }

    /*
     * WARNING - void declaration
     */
    private static final CommentLoadResult loadMessages$lambda-23(MessageQueryDto dto) {
        void $this$mapTo$iv$iv;
        List<EkoMessageDto> list = dto.getMessages();
        Intrinsics.checkNotNullExpressionValue(list, (String)"dto.messages");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EkoMessageDto ekoMessageDto = (EkoMessageDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMessageId());
        }
        List ids = (List)destination$iv$iv;
        Object object = dto.getToken();
        if (object == null || (object = ((EkoQueryToken)object).getNext()) == null) {
            object = "";
        }
        Object token = object;
        return new CommentLoadResult((String)token, ids);
    }

    private static final AmityMessage getLatestMessage$lambda-24(EkoMessageEntity it) {
        MessageModelMapper messageModelMapper = new MessageModelMapper();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return messageModelMapper.map(it);
    }

    private static final Boolean isFlaggedByMe$lambda-25(JsonObject it) {
        return it.get("isFlagByMe").getAsBoolean();
    }

    static {
        AmityMessage.DataType[] dataTypeArray = new AmityMessage.DataType[]{AmityMessage.DataType.IMAGE, AmityMessage.DataType.FILE, AmityMessage.DataType.AUDIO, AmityMessage.DataType.VIDEO};
        fileUploadingTypes = CollectionsKt.listOf((Object[])dataTypeArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/message/MessageRepository$Companion;", "", "()V", "fileUploadingTypes", "", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AmityMessage.DataType.values().length];
            nArray[AmityMessage.DataType.IMAGE.ordinal()] = 1;
            nArray[AmityMessage.DataType.FILE.ordinal()] = 2;
            nArray[AmityMessage.DataType.AUDIO.ordinal()] = 3;
            nArray[AmityMessage.DataType.VIDEO.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

