/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.infra.mqtt;

import co.amity.rxbridge.CompletableKt;
import co.amity.rxbridge.FlowableKt;
import co.amity.rxbridge.SingleKt;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;
import com.amity.socialcloud.sdk.infra.mqtt.listener.MqttEventListener;
import com.amity.socialcloud.sdk.infra.mqtt.listener.MqttEventListeners;
import com.amity.socialcloud.sdk.infra.mqtt.payload.MqttPayload;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.events.AmityTopic;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.UserDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.google.gson.JsonObject;
import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3ConnAckException;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAckReturnCode;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3SubscribeBuilder;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.suback.Mqtt3SubAck;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3Unsubscribe;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3UnsubscribeBuilder;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.processors.PublishProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 +2\u00020\u0001:\u0002*+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\u0006\u0010\u001a\u001a\u00020\u0015J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\b\u0010\u001f\u001a\u00020\u0010H\u0016J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\n\u001a0\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0017\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b\u00a2\u0006\u0002\b\u000e0\u000b\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "autoSubscribeTopics", "", "Lcom/amity/socialcloud/sdk/model/core/events/AmityTopic;", "connectRelay", "Lio/reactivex/rxjava3/processors/PublishProcessor;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "kotlin.jvm.PlatformType", "Lio/reactivex/rxjava3/annotations/NonNull;", "addClientListeners", "", "authClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "autoSubscribe", "connect", "Lio/reactivex/rxjava3/core/Completable;", "account", "createEventSubscription", "Lio/reactivex/rxjava3/disposables/Disposable;", "destroy", "disconnect", "establish", "generateClientId", "", "newAccount", "handleTokenExpire", "initMqttClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "clientId", "username", "password", "", "obsoleteClient", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "AuthenticatedMqttClient", "Companion", "amity-sdk_release"})
public final class AmityMqttClient
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final PublishProcessor<EkoAccount> connectRelay;
    @NotNull
    private final List<AmityTopic> autoSubscribeTopics;
    @NotNull
    private static final CompositeDisposable subscriptions = new CompositeDisposable();
    @Nullable
    private static AuthenticatedMqttClient activeClient;
    @NotNull
    private static final String TAG;

    public AmityMqttClient(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.connectRelay = PublishProcessor.create();
        this.connectRelay.concatMapCompletable(arg_0 -> AmityMqttClient._init_$lambda-1(this, arg_0)).subscribeOn(Schedulers.io()).doOnError(AmityMqttClient::_init_$lambda-2).subscribe();
        Object[] objectArray = new AmityTopic[]{new AmityTopic.NETWORK(), new AmityTopic.SMART_CHANNEL(), new AmityTopic.SMART_MESSAGE_FEED(), new AmityTopic.SMART_MESSAGE()};
        this.autoSubscribeTopics = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        AmityLog.INSTANCE.tag("SSM3").e("mqtt session change: " + sessionState, new Object[0]);
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        AmityLog.INSTANCE.tag("SSM3").e("mqtt session establish: " + this.hashCode(), new Object[0]);
        this.connectRelay.onNext((Object)account);
    }

    @Override
    public void destroy() {
        block0: {
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            if (authenticatedMqttClient == null) break block0;
            AuthenticatedMqttClient it = authenticatedMqttClient;
            boolean bl = false;
            this.obsoleteClient(it).subscribeOn(Schedulers.io()).subscribe();
        }
    }

    @Override
    public void handleTokenExpire() {
        block0: {
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            if (authenticatedMqttClient == null) break block0;
            AuthenticatedMqttClient it = authenticatedMqttClient;
            boolean bl = false;
            this.obsoleteClient(it).subscribeOn(Schedulers.io()).subscribe();
        }
    }

    @NotNull
    public final io.reactivex.rxjava3.core.Completable disconnect() {
        AuthenticatedMqttClient authenticatedMqttClient;
        block3: {
            block2: {
                authenticatedMqttClient = activeClient;
                if (authenticatedMqttClient == null) break block2;
                AuthenticatedMqttClient p0 = authenticatedMqttClient;
                boolean bl = false;
                io.reactivex.rxjava3.core.Completable completable = this.obsoleteClient(p0);
                authenticatedMqttClient = completable;
                if (completable != null) break block3;
            }
            io.reactivex.rxjava3.core.Completable completable = io.reactivex.rxjava3.core.Completable.complete();
            authenticatedMqttClient = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete()");
        }
        return authenticatedMqttClient;
    }

    private final io.reactivex.rxjava3.core.Completable connect(EkoAccount account) {
        Mqtt3RxClient mqtt3RxClient;
        block7: {
            block6: {
                Mqtt3RxClient mqttClient;
                Mqtt3RxClient mqtt3RxClient2;
                String clientId = this.generateClientId(account);
                UserDao userDao = UserDatabase.get().userDao();
                UserEntity user = userDao.getByIdNow(account.getUserId());
                Object object = user;
                if (object == null || (object = ((UserEntity)object).getMid()) == null) {
                    object = "";
                }
                Object username = object;
                String string = account.getAccessToken();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"account.accessToken");
                String string2 = string;
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] password = byArray;
                try {
                    mqtt3RxClient2 = this.initMqttClient(clientId, (String)username, password);
                }
                catch (Exception e) {
                    mqtt3RxClient2 = null;
                }
                if ((mqtt3RxClient = (mqttClient = mqtt3RxClient2)) == null) break block6;
                Mqtt3RxClient it = mqtt3RxClient;
                boolean bl = false;
                Completable completable = ((io.reactivex.Single)((Mqtt3ConnectBuilder.Nested)((Mqtt3ConnectBuilder.Nested)mqttClient.connectWith().cleanSession(false)).keepAlive(60)).applyConnect()).ignoreElement().doOnSubscribe(arg_0 -> AmityMqttClient.connect$lambda-8$lambda-5(clientId, account, arg_0)).doOnComplete(() -> AmityMqttClient.connect$lambda-8$lambda-6(clientId, account, mqttClient, this)).doOnError(AmityMqttClient::connect$lambda-8$lambda-7);
                Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"mqttClient.connectWith()\u2026ge)\n                    }");
                io.reactivex.rxjava3.core.Completable completable2 = CompletableKt.toRx3((Completable)completable);
                mqtt3RxClient = completable2;
                if (completable2 != null) break block7;
            }
            io.reactivex.rxjava3.core.Completable completable = io.reactivex.rxjava3.core.Completable.complete();
            mqtt3RxClient = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete()");
        }
        return mqtt3RxClient;
    }

    private final String generateClientId(EkoAccount newAccount) {
        String string = newAccount.getDeviceId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newAccount.deviceId");
        return string;
    }

    private final Mqtt3RxClient initMqttClient(String clientId, String username, byte[] password) {
        Mqtt3RxClient mqtt3RxClient = ((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)MqttClient.builder().useMqttVersion3().identifier(clientId)).serverHost(EkoEndpoint.INSTANCE.getMqttUrl())).serverPort(443)).sslWithDefaultConfig()).simpleAuth().username(username)).password(password)).applySimpleAuth()).automaticReconnectWithDefaultConfig()).addConnectedListener(AmityMqttClient::initMqttClient$lambda-9)).addDisconnectedListener(arg_0 -> AmityMqttClient.initMqttClient$lambda-10(clientId, arg_0))).buildRx();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3RxClient, (String)"builder()\n              \u2026               .buildRx()");
        return mqtt3RxClient;
    }

    private final io.reactivex.rxjava3.core.Completable obsoleteClient(AuthenticatedMqttClient authClient) {
        subscriptions.clear();
        activeClient = null;
        Completable completable = authClient.getMqttClient().disconnect();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"authClient.mqttClient.disconnect()");
        io.reactivex.rxjava3.core.Completable completable2 = CompletableKt.toRx3((Completable)completable).subscribeOn(Schedulers.io()).doOnSubscribe(arg_0 -> AmityMqttClient.obsoleteClient$lambda-11(authClient, arg_0)).doOnComplete(() -> AmityMqttClient.obsoleteClient$lambda-12(authClient)).doOnError(AmityMqttClient::obsoleteClient$lambda-13);
        Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"authClient.mqttClient.di\u2026essage)\n                }");
        return completable2;
    }

    private final io.reactivex.rxjava3.disposables.Disposable createEventSubscription(AuthenticatedMqttClient authClient) {
        Mqtt3RxClient mqttClient = authClient.getMqttClient();
        Flowable flowable = mqttClient.publishes(MqttGlobalPublishFilter.ALL);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"mqttClient\n             \u2026tGlobalPublishFilter.ALL)");
        io.reactivex.rxjava3.disposables.Disposable disposable = FlowableKt.toRx3((Flowable)flowable).subscribeOn(Schedulers.io()).doOnNext(arg_0 -> AmityMqttClient.createEventSubscription$lambda-15(authClient, this, arg_0)).doOnError(AmityMqttClient::createEventSubscription$lambda-16).subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"mqttClient\n             \u2026             .subscribe()");
        return disposable;
    }

    private final void addClientListeners(AuthenticatedMqttClient authClient) {
        io.reactivex.rxjava3.disposables.Disposable eventSubscription = this.createEventSubscription(authClient);
        subscriptions.add(eventSubscription);
    }

    private final void autoSubscribe() {
        Iterable $this$forEach$iv = this.autoSubscribeTopics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmityTopic topic = (AmityTopic)element$iv;
            boolean bl = false;
            io.reactivex.rxjava3.disposables.Disposable topicSubscription = Companion.subscribe(topic).subscribeOn(Schedulers.io()).doOnError(arg_0 -> AmityMqttClient.autoSubscribe$lambda-18$lambda-17(topic, arg_0)).subscribe();
            subscriptions.add(topicSubscription);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final CompletableSource _init_$lambda-1(AmityMqttClient this$0, EkoAccount account) {
        CompletableSource completableSource;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AuthenticatedMqttClient authenticatedMqttClient = activeClient;
        if (authenticatedMqttClient != null) {
            AuthenticatedMqttClient client = authenticatedMqttClient;
            boolean bl = false;
            io.reactivex.rxjava3.core.Completable completable = this$0.obsoleteClient(client).onErrorComplete();
            Intrinsics.checkNotNullExpressionValue((Object)account, (String)"account");
            io.reactivex.rxjava3.core.Completable completable2 = completable.andThen((CompletableSource)this$0.connect(account));
            authenticatedMqttClient = completable2;
            if (completable2 != null) {
                completableSource = (CompletableSource)authenticatedMqttClient;
                return completableSource;
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)account, (String)"account");
        completableSource = (CompletableSource)this$0.connect(account).onErrorComplete();
        return completableSource;
    }

    private static final void _init_$lambda-2(Throwable it) {
        AmityLog.INSTANCE.tag(TAG).e("Fail to connect with error: " + it, new Object[0]);
    }

    private static final void connect$lambda-8$lambda-5(String $clientId, EkoAccount $account, Disposable it) {
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$account, (String)"$account");
        AmityLog.INSTANCE.tag(TAG).e("Connecting client: " + $clientId + " userId: " + $account.getUserId(), new Object[0]);
    }

    private static final void connect$lambda-8$lambda-6(String $clientId, EkoAccount $account, Mqtt3RxClient $mqttClient, AmityMqttClient this$0) {
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$account, (String)"$account");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AmityLog.INSTANCE.tag(TAG).e("Connected client: " + $clientId + " userId: " + $account.getUserId(), new Object[0]);
        AuthenticatedMqttClient authClient = new AuthenticatedMqttClient($clientId, $account, $mqttClient);
        activeClient = authClient;
        this$0.addClientListeners(authClient);
        this$0.autoSubscribe();
    }

    private static final void connect$lambda-8$lambda-7(Throwable it) {
        AmityLog.INSTANCE.tag(TAG).e("Connection exception: " + it.getMessage(), new Object[0]);
    }

    private static final void initMqttClient$lambda-9(MqttClientConnectedContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AmityLog.INSTANCE.tag(TAG).e("mqtt connected", new Object[0]);
    }

    /*
     * Unable to fully structure code
     */
    private static final void initMqttClient$lambda-10(String $clientId, MqttClientDisconnectedContext it) {
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        v0 = it.getCause();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it.cause");
        exception = v0;
        if (AmityMqttClient.activeClient == null) ** GOTO lbl-1000
        v1 = AmityMqttClient.activeClient;
        if (!Intrinsics.areEqual((Object)(v1 != null ? v1.getClientId() : null), (Object)$clientId)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        isNotActive = v2;
        hasValidDisconnectReason = exception instanceof Mqtt3ConnAckException != false && (((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.IDENTIFIER_REJECTED || ((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.UNSUPPORTED_PROTOCOL_VERSION || ((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.BAD_USER_NAME_OR_PASSWORD || ((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.NOT_AUTHORIZED);
        v3 = shouldNotReconnect = isNotActive != false || hasValidDisconnectReason != false;
        if (shouldNotReconnect) {
            it.getReconnector().reconnect(false);
        }
        AmityLog.INSTANCE.tag(AmityMqttClient.TAG).e("mqtt disconnected || isNotActive: " + isNotActive + " || hasValidDisconnectReason: " + hasValidDisconnectReason + ' ', new Object[0]);
        AmityLog.INSTANCE.tag(AmityMqttClient.TAG).e("mqtt disconnected || cause: " + exception, new Object[0]);
    }

    private static final void obsoleteClient$lambda-11(AuthenticatedMqttClient $authClient, io.reactivex.rxjava3.disposables.Disposable it) {
        Intrinsics.checkNotNullParameter((Object)$authClient, (String)"$authClient");
        AmityLog.INSTANCE.tag(TAG).e("Disconnecting client: \" + " + $authClient.getClientId() + " + \" userId : \" + " + $authClient.getAccount().getUserId(), new Object[0]);
    }

    private static final void obsoleteClient$lambda-12(AuthenticatedMqttClient $authClient) {
        Intrinsics.checkNotNullParameter((Object)$authClient, (String)"$authClient");
        AmityLog.INSTANCE.tag(TAG).e("Disconnected client: \" + " + $authClient.getClientId() + " + \" userId : \" + " + $authClient.getAccount().getUserId(), new Object[0]);
    }

    private static final void obsoleteClient$lambda-13(Throwable it) {
        AmityLog.INSTANCE.tag(TAG).e("Disconnect error: " + it.getMessage(), new Object[0]);
    }

    private static final void createEventSubscription$lambda-15(AuthenticatedMqttClient $authClient, AmityMqttClient this$0, Mqtt3Publish it) {
        boolean isNotActiveClient;
        Intrinsics.checkNotNullParameter((Object)$authClient, (String)"$authClient");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AuthenticatedMqttClient authenticatedMqttClient = activeClient;
        boolean bl = isNotActiveClient = !Intrinsics.areEqual((Object)$authClient.getClientId(), (Object)(authenticatedMqttClient != null ? authenticatedMqttClient.getClientId() : null));
        if (isNotActiveClient) {
            this$0.obsoleteClient($authClient).subscribeOn(Schedulers.io()).subscribe();
            return;
        }
        try {
            byte[] byArray = it.getPayloadAsBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.payloadAsBytes");
            byte[] byArray2 = byArray;
            String payload = new String(byArray2, Charsets.UTF_8);
            AmityLog.INSTANCE.tag(TAG).d("received event: " + payload, new Object[0]);
            MqttPayload event = (MqttPayload)EkoGson.get().fromJson(payload, MqttPayload.class);
            MqttEventListener<Object> listener = MqttEventListeners.INSTANCE.getMap().get(event.getEventType());
            if (listener != null) {
                JsonObject jsonObject = event.getData();
                if (jsonObject != null) {
                    JsonObject data = jsonObject;
                    boolean bl2 = false;
                    listener.onEvent$amity_sdk_release(data);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void createEventSubscription$lambda-16(Throwable it) {
    }

    private static final void autoSubscribe$lambda-18$lambda-17(AmityTopic $topic, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$topic, (String)"$topic");
        AmityLog.INSTANCE.tag(TAG).e("Failed to subscribe " + $topic.getNonce$amity_sdk_release(), new Object[0]);
    }

    static {
        TAG = "AmityMqtt";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "", "clientId", "", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "mqttClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "(Ljava/lang/String;Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;)V", "getAccount", "()Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "getClientId", "()Ljava/lang/String;", "getMqttClient", "()Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "amity-sdk_release"})
    public static final class AuthenticatedMqttClient {
        @NotNull
        private final String clientId;
        @NotNull
        private final EkoAccount account;
        @NotNull
        private final Mqtt3RxClient mqttClient;

        public AuthenticatedMqttClient(@NotNull String clientId, @NotNull EkoAccount account, @NotNull Mqtt3RxClient mqttClient) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)mqttClient, (String)"mqttClient");
            this.clientId = clientId;
            this.account = account;
            this.mqttClient = mqttClient;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final EkoAccount getAccount() {
            return this.account;
        }

        @NotNull
        public final Mqtt3RxClient getMqttClient() {
            return this.mqttClient;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final EkoAccount component2() {
            return this.account;
        }

        @NotNull
        public final Mqtt3RxClient component3() {
            return this.mqttClient;
        }

        @NotNull
        public final AuthenticatedMqttClient copy(@NotNull String clientId, @NotNull EkoAccount account, @NotNull Mqtt3RxClient mqttClient) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)mqttClient, (String)"mqttClient");
            return new AuthenticatedMqttClient(clientId, account, mqttClient);
        }

        public static /* synthetic */ AuthenticatedMqttClient copy$default(AuthenticatedMqttClient authenticatedMqttClient, String string, EkoAccount ekoAccount, Mqtt3RxClient mqtt3RxClient, int n, Object object) {
            if ((n & 1) != 0) {
                string = authenticatedMqttClient.clientId;
            }
            if ((n & 2) != 0) {
                ekoAccount = authenticatedMqttClient.account;
            }
            if ((n & 4) != 0) {
                mqtt3RxClient = authenticatedMqttClient.mqttClient;
            }
            return authenticatedMqttClient.copy(string, ekoAccount, mqtt3RxClient);
        }

        @NotNull
        public String toString() {
            return "AuthenticatedMqttClient(clientId=" + this.clientId + ", account=" + this.account + ", mqttClient=" + this.mqttClient + ')';
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = result * 31 + this.account.hashCode();
            result = result * 31 + this.mqttClient.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticatedMqttClient)) {
                return false;
            }
            AuthenticatedMqttClient authenticatedMqttClient = (AuthenticatedMqttClient)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)authenticatedMqttClient.clientId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.account, (Object)authenticatedMqttClient.account)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mqttClient, (Object)authenticatedMqttClient.mqttClient);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "activeClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "subscriptions", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "getCurrentClient", "Lio/reactivex/rxjava3/core/Single;", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "subscribe", "Lio/reactivex/rxjava3/core/Completable;", "mqttTopic", "Lcom/amity/socialcloud/sdk/model/core/events/AmityTopic;", "unsubscribe", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final io.reactivex.rxjava3.core.Completable subscribe(@NotNull AmityTopic mqttTopic) {
            Intrinsics.checkNotNullParameter((Object)mqttTopic, (String)"mqttTopic");
            io.reactivex.rxjava3.core.Completable completable = mqttTopic.generateTopic$amity_sdk_release().flatMapCompletable(Companion::subscribe$lambda-3);
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"mqttTopic.generateTopic(\u2026  }\n                    }");
            return completable;
        }

        @NotNull
        public final io.reactivex.rxjava3.core.Completable unsubscribe(@NotNull AmityTopic mqttTopic) {
            Intrinsics.checkNotNullParameter((Object)mqttTopic, (String)"mqttTopic");
            io.reactivex.rxjava3.core.Completable completable = mqttTopic.generateTopic$amity_sdk_release().flatMapCompletable(Companion::unsubscribe$lambda-5);
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"mqttTopic.generateTopic(\u2026  }\n                    }");
            return completable;
        }

        private final Single<Mqtt3RxClient> getCurrentClient() {
            Single single;
            Mqtt3RxClient client;
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            Object object = client = authenticatedMqttClient != null ? authenticatedMqttClient.getMqttClient() : null;
            if (client == null) {
                AmityException exception = AmityException.Companion.create("Failed to subscribe", null, AmityError.UNKNOWN);
                Single single2 = Single.error((Throwable)exception);
                single = single2;
                Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"{\n                val ex\u2026(exception)\n            }");
            } else {
                Single single3 = Single.just((Object)client);
                single = single3;
                Intrinsics.checkNotNullExpressionValue((Object)single3, (String)"{\n                Single\u2026ust(client)\n            }");
            }
            return single;
        }

        private static final void subscribe$lambda-3$lambda-2$lambda-0(String $topic, Mqtt3SubAck it) {
            AmityLog.INSTANCE.tag(Companion.getTAG()).d("Subscribed to " + $topic, new Object[0]);
        }

        private static final SingleSource subscribe$lambda-3$lambda-2$lambda-1(String $topic, Throwable it) {
            AmityLog.INSTANCE.tag(Companion.getTAG()).e("Failed to subscribe " + $topic, new Object[0]);
            AmityException exception = AmityException.Companion.create("Failed to subscribe", null, AmityError.UNKNOWN);
            return (SingleSource)Single.error((Throwable)exception);
        }

        private static final CompletableSource subscribe$lambda-3$lambda-2(String $topic, Mqtt3RxClient client) {
            Mqtt3Subscribe mqtt3Subscribe = ((Mqtt3SubscribeBuilder.Start.Complete)((Mqtt3SubscribeBuilder.Start.Complete)Mqtt3Subscribe.builder().topicFilter($topic)).qos(MqttQos.AT_LEAST_ONCE)).build();
            Intrinsics.checkNotNullExpressionValue((Object)mqtt3Subscribe, (String)"builder()\n              \u2026                 .build()");
            Mqtt3Subscribe subscribeMessage = mqtt3Subscribe;
            io.reactivex.Single single = client.subscribe(subscribeMessage);
            Intrinsics.checkNotNullExpressionValue((Object)single, (String)"client.subscribe(subscribeMessage)");
            return (CompletableSource)SingleKt.toRx3((io.reactivex.Single)single).doOnSuccess(arg_0 -> Companion.subscribe$lambda-3$lambda-2$lambda-0($topic, arg_0)).onErrorResumeNext(arg_0 -> Companion.subscribe$lambda-3$lambda-2$lambda-1($topic, arg_0)).ignoreElement();
        }

        private static final CompletableSource subscribe$lambda-3(String topic) {
            return (CompletableSource)Companion.getCurrentClient().flatMapCompletable(arg_0 -> Companion.subscribe$lambda-3$lambda-2(topic, arg_0));
        }

        private static final CompletableSource unsubscribe$lambda-5$lambda-4(String $topic, Mqtt3RxClient it) {
            Mqtt3Unsubscribe mqtt3Unsubscribe = ((Mqtt3UnsubscribeBuilder.Complete)Mqtt3Unsubscribe.builder().topicFilter($topic)).build();
            Intrinsics.checkNotNullExpressionValue((Object)mqtt3Unsubscribe, (String)"builder()\n              \u2026                 .build()");
            Mqtt3Unsubscribe unsubscribeMessage = mqtt3Unsubscribe;
            Completable completable = it.unsubscribe(unsubscribeMessage);
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"it.unsubscribe(unsubscribeMessage)");
            return (CompletableSource)CompletableKt.toRx3((Completable)completable);
        }

        private static final CompletableSource unsubscribe$lambda-5(String topic) {
            return (CompletableSource)Companion.getCurrentClient().flatMapCompletable(arg_0 -> Companion.unsubscribe$lambda-5$lambda-4(topic, arg_0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

