/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.session;

import android.util.Log;
import com.amity.socialcloud.sdk.core.domain.session.GetCurrentAccountUseCase;
import com.amity.socialcloud.sdk.core.exception.EntityNotFoundException;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionLifeCycle;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.core.session.transformer.SessionLifeCycleTransformer;
import com.amity.socialcloud.sdk.core.session.transformer.SessionStateTransformer;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "getSessionState", "()Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "setSessionState", "(Lcom/amity/socialcloud/sdk/core/session/model/SessionState;)V", "observeAppEvent", "", "observeSessionState", "thisIsTestingLog", "verifyAccount", "amity-sdk_release"})
public final class SessionStateManager {
    @NotNull
    private final AppEventBus appEventBus;
    @NotNull
    private final SessionLifeCycleEventBus sessionLifeCycleEventBus;
    @NotNull
    private final SessionStateEventBus sessionStateEventBus;
    @NotNull
    private SessionState sessionState;

    public SessionStateManager(@NotNull AppEventBus appEventBus, @NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)appEventBus, (String)"appEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        this.appEventBus = appEventBus;
        this.sessionLifeCycleEventBus = sessionLifeCycleEventBus;
        this.sessionStateEventBus = sessionStateEventBus;
        this.observeAppEvent();
        this.observeSessionState();
        this.verifyAccount();
        this.thisIsTestingLog();
        this.sessionState = SessionState.NotLoggedIn.INSTANCE;
    }

    @NotNull
    public final SessionState getSessionState() {
        return this.sessionState;
    }

    public final void setSessionState(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"<set-?>");
        this.sessionState = sessionState;
    }

    private final void observeAppEvent() {
        this.appEventBus.observe().doOnNext(arg_0 -> SessionStateManager.observeAppEvent$lambda-1(this, arg_0)).subscribe();
    }

    private final void observeSessionState() {
        this.sessionStateEventBus.observe().doOnNext(arg_0 -> SessionStateManager.observeSessionState$lambda-3(this, arg_0)).subscribe();
    }

    private final void verifyAccount() {
        new GetCurrentAccountUseCase().execute().subscribeOn(Schedulers.io()).doOnSuccess(arg_0 -> SessionStateManager.verifyAccount$lambda-4(this, arg_0)).doOnError(arg_0 -> SessionStateManager.verifyAccount$lambda-5(this, arg_0)).subscribe();
    }

    private final void thisIsTestingLog() {
        this.sessionLifeCycleEventBus.observe().doOnNext(SessionStateManager::thisIsTestingLog$lambda-6).subscribe();
        this.appEventBus.observe().doOnNext(SessionStateManager::thisIsTestingLog$lambda-7).subscribe();
    }

    private static final void observeAppEvent$lambda-1(SessionStateManager this$0, AppEvent appEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SessionState sessionState = this$0.sessionState;
            Intrinsics.checkNotNullExpressionValue((Object)appEvent, (String)"appEvent");
            SessionState sessionState2 = SessionStateTransformer.INSTANCE.transform(sessionState, appEvent);
            if (sessionState2 == null) break block0;
            SessionState sessionState3 = sessionState2;
            boolean bl = false;
            this$0.sessionState = sessionState3;
            this$0.sessionStateEventBus.publish(this$0.sessionState);
        }
    }

    private static final void observeSessionState$lambda-3(SessionStateManager this$0, SessionState sessionState) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)sessionState, (String)"sessionState");
            this$0.sessionState = sessionState;
            Log.e((String)"SSM3", (String)("sessionStateEventBus: " + sessionState));
            SessionLifeCycle sessionLifeCycle = SessionLifeCycleTransformer.INSTANCE.transform(sessionState);
            if (sessionLifeCycle == null) break block0;
            SessionLifeCycle sessionLifeCycle2 = sessionLifeCycle;
            boolean bl = false;
            this$0.sessionLifeCycleEventBus.publish(sessionLifeCycle2);
        }
    }

    private static final void verifyAccount$lambda-4(SessionStateManager this$0, EkoAccount it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CharSequence charSequence = it.getAccessToken();
        if (!(charSequence == null || charSequence.length() == 0)) {
            this$0.appEventBus.publish(AppEvent.AppLaunchWithUser.INSTANCE);
            SessionLifeCycleEventBus sessionLifeCycleEventBus = this$0.sessionLifeCycleEventBus;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            sessionLifeCycleEventBus.publish(new SessionLifeCycle.Establish(it));
        } else {
            this$0.appEventBus.publish(AppEvent.AppLaunchWithoutUser.INSTANCE);
        }
    }

    private static final void verifyAccount$lambda-5(SessionStateManager this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (it instanceof EntityNotFoundException) {
            this$0.appEventBus.publish(AppEvent.AppLaunchWithoutUser.INSTANCE);
        }
    }

    private static final void thisIsTestingLog$lambda-6(SessionLifeCycle it) {
        Log.e((String)"SSM3", (String)("sessionLifeCycleEventBus: " + it));
    }

    private static final void thisIsTestingLog$lambda-7(AppEvent it) {
        Log.e((String)"SSM3", (String)("appEventBus: " + it));
    }
}

