/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.chat.domain.marker.sync.SyncMarkerUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.user.GetUserMarkerUseCase;
import com.amity.socialcloud.sdk.core.MarkerEvent;
import com.amity.socialcloud.sdk.core.MarkerSyncEvent;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel;
import com.ekoapp.ekosdk.internal.api.dto.UserMarkerDto;
import com.ekoapp.ekosdk.internal.api.dto.UserMarkersDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001eH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010 \u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\bH\u0002J\u0006\u0010&\u001a\u00020\u0017J\u0006\u0010'\u001a\u00020\u0017J\b\u0010(\u001a\u00020\u0013H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014 \u0015*\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00140\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/amity/socialcloud/sdk/core/MarkerSyncEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "deviceLastSyncAt", "Lorg/joda/time/DateTime;", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "events", "", "Lcom/amity/socialcloud/sdk/core/MarkerSyncEvent;", "isReadyToSync", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isWaitingForResponse", "", "timer", "Lio/reactivex/rxjava3/core/Completable;", "Lio/reactivex/rxjava3/annotations/NonNull;", "kotlin.jvm.PlatformType", "addNewEvent", "", "event", "destroy", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "fetchDeviceLastSyncAt", "Lio/reactivex/rxjava3/core/Single;", "getDeviceLastSyncAt", "handleTokenExpire", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "saveDeviceLastSyncAt", "lastSyncAt", "startMarkerSync", "stopMarkerSync", "timerDidTrigger", "Companion", "amity-sdk_release"})
public final class MarkerSyncEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Completable timer;
    private boolean isWaitingForResponse;
    @NotNull
    private final List<MarkerSyncEvent> events;
    @Nullable
    private DateTime deviceLastSyncAt;
    @NotNull
    private AtomicBoolean isReadyToSync;
    @NotNull
    private final CompositeDisposable disposable;
    private static final long SYNC_INTERVAL = 2L;
    @NotNull
    private static final List<AmityChannel.Type> SUPPORT_CHANNEL_TYPES;

    public MarkerSyncEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.timer = Flowable.interval((long)2L, (TimeUnit)TimeUnit.SECONDS).flatMapCompletable(arg_0 -> MarkerSyncEngine.timer$lambda-0(this, arg_0)).subscribeOn(Schedulers.io());
        this.events = new ArrayList();
        this.isReadyToSync = new AtomicBoolean();
        this.disposable = new CompositeDisposable();
        this.isReadyToSync.set(false);
        MarkerEventBus.INSTANCE.observe().subscribeOn(Schedulers.io()).doOnNext(arg_0 -> MarkerSyncEngine._init_$lambda-1(this, arg_0)).subscribe();
    }

    public final void startMarkerSync() {
        this.addNewEvent(MarkerSyncEvent.START_SYNCING);
        if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
            this.disposable.clear();
            Disposable disposable = this.timer.subscribe();
            CompositeDisposable compositeDisposable = this.disposable;
            Disposable p0 = disposable;
            boolean bl = false;
            compositeDisposable.add(p0);
        }
    }

    public final void stopMarkerSync() {
        if (this.disposable.size() > 0) {
            this.disposable.clear();
            this.events.clear();
        }
        this.isWaitingForResponse = false;
    }

    private final Completable timerDidTrigger() {
        Completable completable;
        if (this.isWaitingForResponse) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"complete()");
        } else if (this.events.isEmpty()) {
            Completable completable3 = Completable.complete();
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"complete()");
        } else if (!this.isReadyToSync.get()) {
            Completable completable4 = Completable.complete();
            completable = completable4;
            Intrinsics.checkNotNullExpressionValue((Object)completable4, (String)"complete()");
        } else {
            this.events.clear();
            this.isWaitingForResponse = true;
            Completable completable5 = this.fetchDeviceLastSyncAt().flatMap(arg_0 -> MarkerSyncEngine.timerDidTrigger$lambda-3(this, arg_0)).doOnSuccess(arg_0 -> MarkerSyncEngine.timerDidTrigger$lambda-5(this, arg_0)).doFinally(() -> MarkerSyncEngine.timerDidTrigger$lambda-6(this)).ignoreElement().subscribeOn(Schedulers.io());
            completable = completable5;
            Intrinsics.checkNotNullExpressionValue((Object)completable5, (String)"{\n\t\t\t\tevents.clear()\n\t\t\t\u2026eOn(Schedulers.io())\n\t\t\t}");
        }
        return completable;
    }

    private final void addNewEvent(MarkerSyncEvent event) {
        this.events.add(event);
    }

    private final Single<Boolean> fetchDeviceLastSyncAt() {
        Single single;
        if (this.deviceLastSyncAt == null) {
            Single single2 = new GetUserMarkerUseCase().execute().doOnSuccess(arg_0 -> MarkerSyncEngine.fetchDeviceLastSyncAt$lambda-8(this, arg_0)).map(MarkerSyncEngine::fetchDeviceLastSyncAt$lambda-9).onErrorReturnItem((Object)true);
            single = single2;
            Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"{\n\t\t\tGetUserMarkerUseCas\u2026ErrorReturnItem(true)\n\t\t}");
        } else {
            Single single3 = Single.just((Object)true);
            single = single3;
            Intrinsics.checkNotNullExpressionValue((Object)single3, (String)"{\n\t\t\tSingle.just(true)\n\t\t}");
        }
        return single;
    }

    private final DateTime getDeviceLastSyncAt() {
        return this.deviceLastSyncAt;
    }

    private final void saveDeviceLastSyncAt(DateTime lastSyncAt) {
        block4: {
            block3: {
                if (this.deviceLastSyncAt == null) break block3;
                DateTime dateTime = this.deviceLastSyncAt;
                boolean bl = dateTime != null ? dateTime.isBefore((ReadableInstant)lastSyncAt) : false;
                if (!bl) break block4;
            }
            this.deviceLastSyncAt = lastSyncAt;
        }
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        if (Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE)) {
            this.isReadyToSync.set(true);
        } else {
            this.isReadyToSync.set(false);
        }
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.isReadyToSync.set(true);
    }

    @Override
    public void destroy() {
        this.stopMarkerSync();
        this.isReadyToSync.set(false);
        this.deviceLastSyncAt = null;
    }

    @Override
    public void handleTokenExpire() {
        this.stopMarkerSync();
        this.isReadyToSync.set(false);
    }

    private static final CompletableSource timer$lambda-0(MarkerSyncEngine this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (CompletableSource)this$0.timerDidTrigger().onErrorComplete();
    }

    private static final void _init_$lambda-1(MarkerSyncEngine this$0, MarkerEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MarkerEvent markerEvent = event;
        if (markerEvent instanceof MarkerEvent.NetworkConnection.Connected) {
            this$0.addNewEvent(MarkerSyncEvent.RESUME);
        } else if (markerEvent instanceof MarkerEvent.NetworkConnection.Disconnected) {
            this$0.isWaitingForResponse = false;
        } else if (markerEvent instanceof MarkerEvent.NewMessage) {
            String string = ((MarkerEvent.NewMessage)event).getMessage().getChannelType();
            Companion companion = Companion;
            String p0 = string;
            boolean bl = false;
            if (companion.isMarkerSyncSupport(p0)) {
                this$0.addNewEvent(MarkerSyncEvent.NEW_MESSAGE);
            }
        } else if (markerEvent instanceof MarkerEvent.MarkerUpdated) {
            this$0.addNewEvent(MarkerSyncEvent.MARKER_UPDATED);
        }
    }

    private static final SingleSource timerDidTrigger$lambda-3(MarkerSyncEngine this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (SingleSource)new SyncMarkerUseCase().execute(this$0.getDeviceLastSyncAt());
    }

    private static final void timerDidTrigger$lambda-5(MarkerSyncEngine this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        List userMarkers = (List)pair.component1();
        boolean hasMoreMarkers = (Boolean)pair.component2();
        UserMarkerDto userMarkerDto = (UserMarkerDto)CollectionsKt.firstOrNull((List)userMarkers);
        if (userMarkerDto != null && (userMarkerDto = userMarkerDto.getLastSyncAt()) != null) {
            UserMarkerDto p0 = userMarkerDto;
            boolean bl = false;
            this$0.saveDeviceLastSyncAt((DateTime)p0);
        }
        if (hasMoreMarkers) {
            this$0.addNewEvent(MarkerSyncEvent.HAS_MORE);
        }
    }

    private static final void timerDidTrigger$lambda-6(MarkerSyncEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isWaitingForResponse = false;
    }

    private static final void fetchDeviceLastSyncAt$lambda-8(MarkerSyncEngine this$0, UserMarkersDto userMarkers) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            UserMarkerDto userMarkerDto = (UserMarkerDto)CollectionsKt.firstOrNull(userMarkers.getUserMarkers());
            if (userMarkerDto == null) break block0;
            UserMarkerDto userMarker = userMarkerDto;
            boolean bl = false;
            this$0.saveDeviceLastSyncAt(userMarker.getLastSyncAt());
        }
    }

    private static final Boolean fetchDeviceLastSyncAt$lambda-9(UserMarkersDto it) {
        return true;
    }

    static {
        AmityChannel.Type[] typeArray = new AmityChannel.Type[]{AmityChannel.Type.COMMUNITY, AmityChannel.Type.CONVERSATION, AmityChannel.Type.BROADCAST};
        SUPPORT_CHANNEL_TYPES = CollectionsKt.listOf((Object[])typeArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/amity/socialcloud/sdk/core/MarkerSyncEngine$Companion;", "", "()V", "SUPPORT_CHANNEL_TYPES", "", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannel$Type;", "SYNC_INTERVAL", "", "isMarkerSyncSupport", "", "type", "", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isMarkerSyncSupport(@Nullable AmityChannel.Type type) {
            boolean bl;
            AmityChannel.Type type2 = type;
            if (type2 != null) {
                AmityChannel.Type type3 = type2;
                List list = SUPPORT_CHANNEL_TYPES;
                AmityChannel.Type p0 = type3;
                boolean bl2 = false;
                bl = list.contains((Object)p0);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isMarkerSyncSupport(@Nullable String type) {
            boolean bl;
            String string = type;
            if (string != null) {
                void $this$mapTo$iv$iv;
                String string2 = string;
                Iterable $this$map$iv = SUPPORT_CHANNEL_TYPES;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AmityChannel.Type type2 = (AmityChannel.Type)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getApiKey());
                }
                List list = (List)destination$iv$iv;
                String p0 = string2;
                boolean bl3 = false;
                bl = list.contains(p0);
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

