/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.session;

import android.util.Log;
import com.amity.socialcloud.sdk.core.domain.session.GetCurrentAccountUseCase;
import com.amity.socialcloud.sdk.core.exception.EntityNotFoundException;
import com.amity.socialcloud.sdk.core.session.SessionStateManager;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionLifeCycle;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.core.session.transformer.SessionLifeCycleTransformer;
import com.amity.socialcloud.sdk.core.session.transformer.SessionStateTransformer;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "getSessionState", "()Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "setSessionState", "(Lcom/amity/socialcloud/sdk/core/session/model/SessionState;)V", "observeAppEvent", "", "observeSessionState", "thisIsTestingLog", "verifyAccount", "amity-sdk_release"})
public final class SessionStateManager {
    @NotNull
    private SessionState sessionState;
    private final AppEventBus appEventBus;
    private final SessionLifeCycleEventBus sessionLifeCycleEventBus;
    private final SessionStateEventBus sessionStateEventBus;

    @NotNull
    public final SessionState getSessionState() {
        return this.sessionState;
    }

    public final void setSessionState(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"<set-?>");
        this.sessionState = sessionState;
    }

    private final void observeAppEvent() {
        this.appEventBus.observe().doOnNext((Consumer)new Consumer<AppEvent>(this){
            final /* synthetic */ SessionStateManager this$0;

            public final void accept(AppEvent appEvent) {
                block0: {
                    SessionState sessionState = this.this$0.getSessionState();
                    AppEvent appEvent2 = appEvent;
                    Intrinsics.checkNotNullExpressionValue((Object)appEvent2, (String)"appEvent");
                    SessionState sessionState2 = SessionStateTransformer.INSTANCE.transform(sessionState, appEvent2);
                    if (sessionState2 == null) break block0;
                    SessionState sessionState3 = sessionState2;
                    boolean bl = false;
                    boolean bl2 = false;
                    SessionState sessionState4 = sessionState3;
                    boolean bl3 = false;
                    this.this$0.setSessionState(sessionState4);
                    SessionStateManager.access$getSessionStateEventBus$p(this.this$0).publish(this.this$0.getSessionState());
                }
            }
            {
                this.this$0 = sessionStateManager;
            }
        }).subscribe();
    }

    private final void observeSessionState() {
        this.sessionStateEventBus.observe().doOnNext((Consumer)new Consumer<SessionState>(this){
            final /* synthetic */ SessionStateManager this$0;

            public final void accept(SessionState sessionState) {
                block0: {
                    Log.e((String)"SSM3", (String)("sessionStateEventBus: " + sessionState));
                    SessionState sessionState2 = sessionState;
                    Intrinsics.checkNotNullExpressionValue((Object)sessionState2, (String)"sessionState");
                    SessionLifeCycle sessionLifeCycle = SessionLifeCycleTransformer.INSTANCE.transform(sessionState2);
                    if (sessionLifeCycle == null) break block0;
                    SessionLifeCycle sessionLifeCycle2 = sessionLifeCycle;
                    boolean bl = false;
                    boolean bl2 = false;
                    SessionLifeCycle sessionLifeCycle3 = sessionLifeCycle2;
                    boolean bl3 = false;
                    SessionStateManager.access$getSessionLifeCycleEventBus$p(this.this$0).publish(sessionLifeCycle3);
                }
            }
            {
                this.this$0 = sessionStateManager;
            }
        }).subscribe();
    }

    private final void verifyAccount() {
        new GetCurrentAccountUseCase().execute().subscribeOn(Schedulers.io()).doOnSuccess((Consumer)new Consumer<EkoAccount>(this){
            final /* synthetic */ SessionStateManager this$0;

            public final void accept(EkoAccount it) {
                EkoAccount ekoAccount = it;
                Intrinsics.checkNotNullExpressionValue((Object)ekoAccount, (String)"it");
                CharSequence charSequence = ekoAccount.getAccessToken();
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    SessionStateManager.access$getAppEventBus$p(this.this$0).publish(AppEvent.AppLaunchWithUser.INSTANCE);
                    SessionStateManager.access$getSessionLifeCycleEventBus$p(this.this$0).publish(new SessionLifeCycle.Establish(it));
                } else {
                    SessionStateManager.access$getAppEventBus$p(this.this$0).publish(AppEvent.AppLaunchWithoutUser.INSTANCE);
                }
            }
            {
                this.this$0 = sessionStateManager;
            }
        }).doOnError((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ SessionStateManager this$0;

            public final void accept(Throwable it) {
                if (it instanceof EntityNotFoundException) {
                    SessionStateManager.access$getAppEventBus$p(this.this$0).publish(AppEvent.AppLaunchWithoutUser.INSTANCE);
                }
            }
            {
                this.this$0 = sessionStateManager;
            }
        }).subscribe();
    }

    private final void thisIsTestingLog() {
        this.sessionLifeCycleEventBus.observe().doOnNext((Consumer)thisIsTestingLog.1.INSTANCE).subscribe();
        this.appEventBus.observe().doOnNext((Consumer)thisIsTestingLog.2.INSTANCE).subscribe();
    }

    public SessionStateManager(@NotNull AppEventBus appEventBus, @NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)appEventBus, (String)"appEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        this.appEventBus = appEventBus;
        this.sessionLifeCycleEventBus = sessionLifeCycleEventBus;
        this.sessionStateEventBus = sessionStateEventBus;
        this.observeAppEvent();
        this.observeSessionState();
        this.verifyAccount();
        this.thisIsTestingLog();
        this.sessionState = SessionState.NotLoggedIn.INSTANCE;
    }

    public static final /* synthetic */ SessionStateEventBus access$getSessionStateEventBus$p(SessionStateManager $this) {
        return $this.sessionStateEventBus;
    }

    public static final /* synthetic */ SessionLifeCycleEventBus access$getSessionLifeCycleEventBus$p(SessionStateManager $this) {
        return $this.sessionLifeCycleEventBus;
    }

    public static final /* synthetic */ AppEventBus access$getAppEventBus$p(SessionStateManager $this) {
        return $this.appEventBus;
    }
}

