/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoReactionDao_Impl
extends EkoReactionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoReactionEntity> __insertionAdapterOfEkoReactionEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoReactionEntity> __deletionAdapterOfEkoReactionEntity;
    private final EntityDeletionOrUpdateAdapter<EkoReactionEntity> __updateAdapterOfEkoReactionEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByPrimaryKeyImpl;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByReferenceIdAndUserIdImpl;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByReferenceIdImpl;

    public EkoReactionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoReactionEntity = new EntityInsertionAdapter<EkoReactionEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `reaction` (`reactionId`,`reactionName`,`userId`,`userDisplayName`,`referenceId`,`referenceType`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoReactionEntity value) {
                if (value.getReactionId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getReactionId());
                }
                if (value.getReactionName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getReactionName());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getUserDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getUserDisplayName());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getReferenceId());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getReferenceType());
                }
                String _tmp = EkoReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp);
                }
                String _tmp_1 = EkoReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_1);
                }
            }
        };
        this.__deletionAdapterOfEkoReactionEntity = new EntityDeletionOrUpdateAdapter<EkoReactionEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `reaction` WHERE `userId` = ? AND `reactionName` = ? AND `referenceType` = ? AND `referenceId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoReactionEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getReactionName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getReactionName());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getReferenceType());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getReferenceId());
                }
            }
        };
        this.__updateAdapterOfEkoReactionEntity = new EntityDeletionOrUpdateAdapter<EkoReactionEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `reaction` SET `reactionId` = ?,`reactionName` = ?,`userId` = ?,`userDisplayName` = ?,`referenceId` = ?,`referenceType` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `userId` = ? AND `reactionName` = ? AND `referenceType` = ? AND `referenceId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoReactionEntity value) {
                if (value.getReactionId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getReactionId());
                }
                if (value.getReactionName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getReactionName());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getUserDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getUserDisplayName());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getReferenceId());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getReferenceType());
                }
                String _tmp = EkoReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp);
                }
                String _tmp_1 = EkoReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_1);
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getUserId());
                }
                if (value.getReactionName() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getReactionName());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getReferenceType());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getReferenceId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from reaction";
                return "DELETE from reaction";
            }
        };
        this.__preparedStmtOfDeleteByPrimaryKeyImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from reaction where referenceId = ? and userId = ? and reactionName = ? and referenceType = ?";
                return "DELETE from reaction where referenceId = ? and userId = ? and reactionName = ? and referenceType = ?";
            }
        };
        this.__preparedStmtOfDeleteByReferenceIdAndUserIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from reaction where referenceId = ? and userId = ? and referenceType = ?";
                return "DELETE from reaction where referenceId = ? and userId = ? and referenceType = ?";
            }
        };
        this.__preparedStmtOfDeleteByReferenceIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from reaction where referenceId = ? and referenceType = ?";
                return "DELETE from reaction where referenceId = ? and referenceType = ?";
            }
        };
    }

    @Override
    void insertImpl(EkoReactionEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoReactionEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoReactionEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoReactionEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoReactionEntity reaction) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoReactionEntity.handle((Object)reaction);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoReactionEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoReactionEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoReactionEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoReactionEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoReactionEntity object) {
        this.__db.beginTransaction();
        try {
            EkoReactionDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoReactionEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoReactionDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoReactionEntity object) {
        this.__db.beginTransaction();
        try {
            EkoReactionDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteByPrimaryKeyImpl(String referenceType, String referenceId, String userId, String reactionName) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByPrimaryKeyImpl.acquire();
        int _argIndex = 1;
        if (referenceId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        _argIndex = 3;
        if (reactionName == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, reactionName);
        }
        _argIndex = 4;
        if (referenceType == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, referenceType);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByPrimaryKeyImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteByReferenceIdAndUserIdImpl(String referenceId, String referenceType, String userId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByReferenceIdAndUserIdImpl.acquire();
        int _argIndex = 1;
        if (referenceId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        _argIndex = 3;
        if (referenceType == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, referenceType);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByReferenceIdAndUserIdImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteByReferenceIdImpl(String referenceId, String referenceType) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByReferenceIdImpl.acquire();
        int _argIndex = 1;
        if (referenceId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (referenceType == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, referenceType);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByReferenceIdImpl.release(_stmt);
        }
    }

    @Override
    DataSource.Factory<Integer, EkoReactionEntity> getAllByReferenceIdImpl(String referenceId, String referenceType) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? order by reaction.createdAt DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? order by reaction.createdAt DESC", (int)2);
        int _argIndex = 1;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        return new DataSource.Factory<Integer, EkoReactionEntity>(){

            public LimitOffsetDataSource<EkoReactionEntity> create() {
                return new LimitOffsetDataSource<EkoReactionEntity>(EkoReactionDao_Impl.this.__db, _statement, false, true, new String[]{"reaction"}){

                    protected List<EkoReactionEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfReactionId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionId");
                        int _cursorIndexOfReactionName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionName");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                        int _cursorIndexOfUserDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userDisplayName");
                        int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"referenceId");
                        int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"referenceType");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<EkoReactionEntity> _res = new ArrayList<EkoReactionEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoReactionEntity _item = new EkoReactionEntity();
                            String _tmpReactionId = cursor.isNull(_cursorIndexOfReactionId) ? null : cursor.getString(_cursorIndexOfReactionId);
                            _item.setReactionId(_tmpReactionId);
                            String _tmpReactionName = cursor.isNull(_cursorIndexOfReactionName) ? null : cursor.getString(_cursorIndexOfReactionName);
                            _item.setReactionName(_tmpReactionName);
                            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpUserDisplayName = cursor.isNull(_cursorIndexOfUserDisplayName) ? null : cursor.getString(_cursorIndexOfUserDisplayName);
                            _item.setUserDisplayName(_tmpUserDisplayName);
                            String _tmpReferenceId = cursor.isNull(_cursorIndexOfReferenceId) ? null : cursor.getString(_cursorIndexOfReferenceId);
                            _item.setReferenceId(_tmpReferenceId);
                            String _tmpReferenceType = cursor.isNull(_cursorIndexOfReferenceType) ? null : cursor.getString(_cursorIndexOfReferenceType);
                            _item.setReferenceType(_tmpReferenceType);
                            String _tmp = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_1 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoReactionEntity> getAllByReferenceIdAndReactionNameImpl(String referenceId, String referenceType, String reactionName) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.reactionName = ? and reaction.referenceType = ? order by reaction.createdAt DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceId = ? and reaction.reactionName = ? and reaction.referenceType = ? order by reaction.createdAt DESC", (int)3);
        int _argIndex = 1;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (reactionName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, reactionName);
        }
        _argIndex = 3;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        return new DataSource.Factory<Integer, EkoReactionEntity>(){

            public LimitOffsetDataSource<EkoReactionEntity> create() {
                return new LimitOffsetDataSource<EkoReactionEntity>(EkoReactionDao_Impl.this.__db, _statement, false, true, new String[]{"reaction"}){

                    protected List<EkoReactionEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfReactionId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionId");
                        int _cursorIndexOfReactionName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionName");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                        int _cursorIndexOfUserDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userDisplayName");
                        int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"referenceId");
                        int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"referenceType");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<EkoReactionEntity> _res = new ArrayList<EkoReactionEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoReactionEntity _item = new EkoReactionEntity();
                            String _tmpReactionId = cursor.isNull(_cursorIndexOfReactionId) ? null : cursor.getString(_cursorIndexOfReactionId);
                            _item.setReactionId(_tmpReactionId);
                            String _tmpReactionName = cursor.isNull(_cursorIndexOfReactionName) ? null : cursor.getString(_cursorIndexOfReactionName);
                            _item.setReactionName(_tmpReactionName);
                            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpUserDisplayName = cursor.isNull(_cursorIndexOfUserDisplayName) ? null : cursor.getString(_cursorIndexOfUserDisplayName);
                            _item.setUserDisplayName(_tmpUserDisplayName);
                            String _tmpReferenceId = cursor.isNull(_cursorIndexOfReferenceId) ? null : cursor.getString(_cursorIndexOfReferenceId);
                            _item.setReferenceId(_tmpReferenceId);
                            String _tmpReferenceType = cursor.isNull(_cursorIndexOfReferenceType) ? null : cursor.getString(_cursorIndexOfReferenceType);
                            _item.setReferenceType(_tmpReferenceType);
                            String _tmp = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_1 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    Maybe<EkoReactionEntity> getMyReactionByReferenceIdAndReactionNameImpl(String referenceId, String referenceType, String reactionName, String userId) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.reactionName = ? and reaction.userId = ? and reaction.referenceType = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceId = ? and reaction.reactionName = ? and reaction.userId = ? and reaction.referenceType = ? LIMIT 1", (int)4);
        int _argIndex = 1;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (reactionName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, reactionName);
        }
        _argIndex = 3;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 4;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        return Maybe.fromCallable((Callable)new Callable<EkoReactionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoReactionEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoReactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoReactionEntity _result;
                    int _cursorIndexOfReactionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionId");
                    int _cursorIndexOfReactionName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionName");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfUserDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userDisplayName");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoReactionEntity();
                        String _tmpReactionId = _cursor.isNull(_cursorIndexOfReactionId) ? null : _cursor.getString(_cursorIndexOfReactionId);
                        _result.setReactionId(_tmpReactionId);
                        String _tmpReactionName = _cursor.isNull(_cursorIndexOfReactionName) ? null : _cursor.getString(_cursorIndexOfReactionName);
                        _result.setReactionName(_tmpReactionName);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpUserDisplayName = _cursor.isNull(_cursorIndexOfUserDisplayName) ? null : _cursor.getString(_cursorIndexOfUserDisplayName);
                        _result.setUserDisplayName(_tmpUserDisplayName);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        _result.setReferenceId(_tmpReferenceId);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        _result.setReferenceType(_tmpReferenceType);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoReactionEntity ekoReactionEntity = _result;
                    return ekoReactionEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<List<EkoReactionEntity>> getAllMyReactionsByReferenceTypeAndReferenceIdImpl(String referenceType, String referenceId, String userId) {
        String _sql = "SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ?", (int)3);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"reaction"}, (Callable)new Callable<List<EkoReactionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoReactionEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoReactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfReactionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionId");
                    int _cursorIndexOfReactionName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionName");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfUserDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userDisplayName");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        EkoReactionEntity _item = new EkoReactionEntity();
                        String _tmpReactionId = _cursor.isNull(_cursorIndexOfReactionId) ? null : _cursor.getString(_cursorIndexOfReactionId);
                        _item.setReactionId(_tmpReactionId);
                        String _tmpReactionName = _cursor.isNull(_cursorIndexOfReactionName) ? null : _cursor.getString(_cursorIndexOfReactionName);
                        _item.setReactionName(_tmpReactionName);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _item.setUserId(_tmpUserId);
                        String _tmpUserDisplayName = _cursor.isNull(_cursorIndexOfUserDisplayName) ? null : _cursor.getString(_cursorIndexOfUserDisplayName);
                        _item.setUserDisplayName(_tmpUserDisplayName);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        _item.setReferenceId(_tmpReferenceId);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        _item.setReferenceType(_tmpReferenceType);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        _result.add(_item);
                    }
                    ArrayList<EkoReactionEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<EkoReactionEntity> getAllMyReactionsByReferenceTypeAndReferenceIdNowImpl(String referenceType, String referenceId, String userId) {
        String _sql = "SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ?", (int)3);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfReactionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionId");
            int _cursorIndexOfReactionName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionName");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfUserDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userDisplayName");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoReactionEntity _item = new EkoReactionEntity();
                String _tmpReactionId = _cursor.isNull(_cursorIndexOfReactionId) ? null : _cursor.getString(_cursorIndexOfReactionId);
                _item.setReactionId(_tmpReactionId);
                String _tmpReactionName = _cursor.isNull(_cursorIndexOfReactionName) ? null : _cursor.getString(_cursorIndexOfReactionName);
                _item.setReactionName(_tmpReactionName);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpUserDisplayName = _cursor.isNull(_cursorIndexOfUserDisplayName) ? null : _cursor.getString(_cursorIndexOfUserDisplayName);
                _item.setUserDisplayName(_tmpUserDisplayName);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                _item.setReferenceId(_tmpReferenceId);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoReactionEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoReactionEntity> getAllByReferenceTypeAndReferenceId(String referenceType, String referenceId) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? order by reaction.createdAt DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? order by reaction.createdAt DESC", (int)2);
        int _argIndex = 1;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfReactionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionId");
            int _cursorIndexOfReactionName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionName");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfUserDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userDisplayName");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoReactionEntity _item = new EkoReactionEntity();
                String _tmpReactionId = _cursor.isNull(_cursorIndexOfReactionId) ? null : _cursor.getString(_cursorIndexOfReactionId);
                _item.setReactionId(_tmpReactionId);
                String _tmpReactionName = _cursor.isNull(_cursorIndexOfReactionName) ? null : _cursor.getString(_cursorIndexOfReactionName);
                _item.setReactionName(_tmpReactionName);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpUserDisplayName = _cursor.isNull(_cursorIndexOfUserDisplayName) ? null : _cursor.getString(_cursorIndexOfUserDisplayName);
                _item.setUserDisplayName(_tmpUserDisplayName);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                _item.setReferenceId(_tmpReferenceId);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoReactionEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoReactionEntity> getAllAfterReactionId(String reactionId) {
        String _sql = "SELECT * from reaction where reaction.reactionId >= ? order by reaction.createdAt DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.reactionId >= ? order by reaction.createdAt DESC", (int)1);
        int _argIndex = 1;
        if (reactionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, reactionId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfReactionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionId");
            int _cursorIndexOfReactionName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionName");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfUserDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userDisplayName");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoReactionEntity _item = new EkoReactionEntity();
                String _tmpReactionId = _cursor.isNull(_cursorIndexOfReactionId) ? null : _cursor.getString(_cursorIndexOfReactionId);
                _item.setReactionId(_tmpReactionId);
                String _tmpReactionName = _cursor.isNull(_cursorIndexOfReactionName) ? null : _cursor.getString(_cursorIndexOfReactionName);
                _item.setReactionName(_tmpReactionName);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpUserDisplayName = _cursor.isNull(_cursorIndexOfUserDisplayName) ? null : _cursor.getString(_cursorIndexOfUserDisplayName);
                _item.setUserDisplayName(_tmpUserDisplayName);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                _item.setReferenceId(_tmpReferenceId);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoReactionEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoReactionEntity> getAllBeforeReactionId(String reactionId) {
        String _sql = "SELECT * from reaction where reaction.reactionId < ? order by reaction.createdAt DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.reactionId < ? order by reaction.createdAt DESC", (int)1);
        int _argIndex = 1;
        if (reactionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, reactionId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfReactionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionId");
            int _cursorIndexOfReactionName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionName");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfUserDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userDisplayName");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoReactionEntity _item = new EkoReactionEntity();
                String _tmpReactionId = _cursor.isNull(_cursorIndexOfReactionId) ? null : _cursor.getString(_cursorIndexOfReactionId);
                _item.setReactionId(_tmpReactionId);
                String _tmpReactionName = _cursor.isNull(_cursorIndexOfReactionName) ? null : _cursor.getString(_cursorIndexOfReactionName);
                _item.setReactionName(_tmpReactionName);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpUserDisplayName = _cursor.isNull(_cursorIndexOfUserDisplayName) ? null : _cursor.getString(_cursorIndexOfUserDisplayName);
                _item.setUserDisplayName(_tmpUserDisplayName);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                _item.setReferenceId(_tmpReferenceId);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoReactionEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoReactionEntity> getAllBetweenReactionId(String fromReactionId, String tillReactionId) {
        String _sql = "SELECT * from reaction where reaction.reactionId BETWEEN ? and ? and reaction.reactionId != ? order by reaction.createdAt DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.reactionId BETWEEN ? and ? and reaction.reactionId != ? order by reaction.createdAt DESC", (int)3);
        int _argIndex = 1;
        if (fromReactionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, fromReactionId);
        }
        _argIndex = 2;
        if (tillReactionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tillReactionId);
        }
        _argIndex = 3;
        if (tillReactionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tillReactionId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfReactionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionId");
            int _cursorIndexOfReactionName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionName");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfUserDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userDisplayName");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoReactionEntity _item = new EkoReactionEntity();
                String _tmpReactionId = _cursor.isNull(_cursorIndexOfReactionId) ? null : _cursor.getString(_cursorIndexOfReactionId);
                _item.setReactionId(_tmpReactionId);
                String _tmpReactionName = _cursor.isNull(_cursorIndexOfReactionName) ? null : _cursor.getString(_cursorIndexOfReactionName);
                _item.setReactionName(_tmpReactionName);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpUserDisplayName = _cursor.isNull(_cursorIndexOfUserDisplayName) ? null : _cursor.getString(_cursorIndexOfUserDisplayName);
                _item.setUserDisplayName(_tmpUserDisplayName);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                _item.setReferenceId(_tmpReferenceId);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoReactionEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

