/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMembershipSortOption;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityRoleDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoRoleDao;
import com.ekoapp.ekosdk.internal.data.model.CommunityMembershipPermissionEntity;
import com.ekoapp.ekosdk.internal.data.model.CommunityMembershipRoleEntity;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.google.common.base.Objects;
import io.reactivex.Flowable;
import java.util.List;

@Dao
public abstract class EkoCommunityMembershipDao
extends EkoObjectDao<CommunityMembershipEntity> {
    private final EkoCommunityDao communityDao;
    private final EkoCommunityRoleDao communityRoleDao;
    private final EkoCommunityPermissionDao communityPermissionDao;

    public EkoCommunityMembershipDao() {
        UserDatabase db = UserDatabase.get();
        this.communityRoleDao = db.communityRoleDao();
        this.communityPermissionDao = db.communityPermissionDao();
        this.communityDao = db.communityDao();
    }

    @Override
    @Delete
    public abstract void delete(CommunityMembershipEntity var1);

    @Override
    @Query(value="DELETE from community_membership")
    public abstract void deleteAll();

    @Query(value="DELETE from community_membership where community_membership.communityId = :communityId")
    abstract void deleteByCommunityIdImpl(String var1);

    @Query(value="SELECT * from community_membership where communityId = :communityId and userId = :userId LIMIT 1")
    abstract CommunityMembershipEntity getByCommunityIdAndUserIdNowImpl(String var1, String var2);

    public CommunityMembershipEntity getByCommunityIdAndUserIdNow(String communityId, String userId) {
        return this.getByCommunityIdAndUserIdNowImpl(communityId, userId);
    }

    @Query(value="SELECT * from community_membership where id = :id LIMIT 1")
    abstract CommunityMembershipEntity getByIdNowImpl(String var1);

    @Override
    public CommunityMembershipEntity getByIdNow(String id) {
        return this.getByIdNowImpl(id);
    }

    @Query(value="SELECT * from community_membership where communityId = :communityId and userId = :userId LIMIT 1")
    abstract Flowable<CommunityMembershipEntity> getByIdImpl(String var1, String var2);

    public Flowable<CommunityMembershipEntity> getById(String communityId, String userId) {
        return this.getByIdImpl(communityId, userId);
    }

    @Transaction
    public void deleteByCommunityId(String communityId) {
        this.deleteByCommunityIdImpl(communityId);
    }

    @Query(value="SELECT * from community_membership, community_member_query_token where community_membership.communityId = :communityId and community_membership.communityMembership in (:memberships) and userId in (SELECT userId from community_role where communityId = :communityId and roleName in (:role)) and (community_member_query_token.communityId = :communityId and community_member_query_token.roles = :queryRoles and community_member_query_token.memberships = :queryMemberships and community_member_query_token.sortOption = :querySortOption and community_member_query_token.pageNumber = 1 and community_member_query_token.ids like '%' || community_membership.id || '%') order by case when :isSortByCreatedACS = 1 then community_membership.createdAt end asc, case when :isSortByCreatedACS = 0 then community_membership.createdAt end desc")
    abstract DataSource.Factory<Integer, CommunityMembershipEntity> getByMembershipsAndRolesImpl(String var1, List<String> var2, List<String> var3, boolean var4, String var5, String var6, String var7);

    @Query(value="SELECT * from community_membership, community_member_query_token where community_membership.communityId = :communityId and community_membership.communityMembership in (:memberships) and (community_member_query_token.communityId = :communityId and community_member_query_token.roles = :queryRoles and community_member_query_token.memberships = :queryMemberships and community_member_query_token.sortOption = :querySortOption and community_member_query_token.pageNumber = 1 and community_member_query_token.ids like '%' || community_membership.id || '%') order by case when :isSortByCreatedACS = 1 then community_membership.createdAt end asc, case when :isSortByCreatedACS = 0 then community_membership.createdAt end desc")
    abstract DataSource.Factory<Integer, CommunityMembershipEntity> getByMembershipsImpl(String var1, List<String> var2, boolean var3, String var4, String var5, String var6);

    public DataSource.Factory<Integer, CommunityMembershipEntity> getMembers(String communityId, List<String> roles, List<String> memberships, AmityCommunityMembershipSortOption sortBy) {
        if (roles == null || roles.isEmpty()) {
            return this.getByMembershipsImpl(communityId, memberships, this.isSortByCreatedACS(sortBy), "", memberships.toString(), sortBy.getApiKey());
        }
        return this.getByMembershipsAndRolesImpl(communityId, roles, memberships, this.isSortByCreatedACS(sortBy), roles.toString(), memberships.toString(), sortBy.getApiKey());
    }

    private Boolean isSortByCreatedACS(AmityCommunityMembershipSortOption sortBy) {
        return sortBy == AmityCommunityMembershipSortOption.FIRST_CREATED;
    }

    @Transaction
    public void updateUser(String userId) {
        this.updateUserImpl(userId);
    }

    @Query(value="UPDATE channel_membership set userId = :userId where userId = :userId")
    abstract void updateUserImpl(String var1);

    @Override
    @Transaction
    public void insert(CommunityMembershipEntity membership) {
        super.insert(membership);
        EkoRoleDao.update(membership, this.communityRoleDao, CommunityMembershipRoleEntity::create);
        EkoPermissionDao.update(membership, this.communityPermissionDao, CommunityMembershipPermissionEntity::create);
        this.updateIsJoined(membership);
    }

    @Override
    @Transaction
    public void insert(List<CommunityMembershipEntity> memberships) {
        super.insert(memberships);
        EkoRoleDao.update(memberships, this.communityRoleDao, CommunityMembershipRoleEntity::create);
        EkoPermissionDao.update(memberships, this.communityPermissionDao, CommunityMembershipPermissionEntity::create);
        for (CommunityMembershipEntity membership : memberships) {
            this.updateIsJoined(membership);
        }
    }

    @Override
    public void update(CommunityMembershipEntity membership) {
        super.update(membership);
        EkoRoleDao.update(membership, this.communityRoleDao, CommunityMembershipRoleEntity::create);
        EkoPermissionDao.update(membership, this.communityPermissionDao, CommunityMembershipPermissionEntity::create);
        this.updateIsJoined(membership);
    }

    private void updateIsJoined(CommunityMembershipEntity membership) {
        if (Objects.equal((Object)membership.getUserId(), (Object)AmityCoreClient.INSTANCE.getUserId())) {
            this.communityDao.updateIsJoined(membership.getCommunityId());
        }
    }
}

